% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dir_control.R
\name{create_dir_struct}
\alias{create_dir_struct}
\title{Initialize the directory structure for automatically storing and structuring results.}
\usage{
create_dir_struct(base_dir)
}
\arguments{
\item{base_dir}{Base directory in which to build directory structure for result output.}
}
\value{
This function does not return a value.
}
\description{
This function initializes and, if necessary, creates the directory structure for output of
analysis based on a provided base directory.  A /results/ folder will be created in the base directory
containing a complete directory structure for all possible results that can be generated by this package.
All visualizations and data aggregation tools rely on this directory structure for data output.
Note that this function will NOT overwrite existing directories.  Initialization of
data directories should be performed seperately using init_data_paths().
}
\examples{
\dontrun{

#Initialize a DEVis directory structure at a base directory.
create_dir_struct(base_dir="/Users/adam/projects/ebola/")

This command will create the following folders:
/Users/adam/projects/ebola/
  /results/
    /DE/
      /boxplot/
      /counts/
      /data/
      /density_plots/
      /divergence/
      /heatmaps/
      /profile_plots/
      /series_plots/
      /volcano/
   /dendrograms/
   /geneplots/
   /group_stats/
   /MDS/
     /standard/
     /hulls/
   /sample_distance/
     /euclidian/
     /poisson/

}
}
\seealso{
\code{\link{init_data_paths}}, \code{\link{set_output_mode}}
}
\keyword{directory}
\keyword{initialization}
\keyword{organization}
\keyword{output}
\keyword{project-management}
