% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{plotObsExpWSAF}
\alias{plotObsExpWSAF}
\title{Plot WSAF}
\usage{
plotObsExpWSAF(obsWSAF, expWSAF, title = "WSAF(observed vs expected)")
}
\arguments{
\item{obsWSAF}{Numeric array of observed WSAF.}

\item{expWSAF}{Numeric array of expected WSAF.}

\item{title}{Figure title.}
}
\description{
Plot observed alternative allele frequency within sample against expected WSAF.
}
\examples{
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageVcf = extractCoverageFromVcf(vcfFile)
obsWSAF = computeObsWSAF( PG0390CoverageVcf$altCount, PG0390CoverageVcf$refCount )
plafFile = system.file("extdata", "labStrains.test.PLAF.txt", package = "DEploid")
PG0390CoverageVcf.deconv = dEploid(paste("-vcf", vcfFile, "-plaf", plafFile, "-noPanel"))
prop = PG0390CoverageVcf.deconv$Proportions[dim(PG0390CoverageVcf.deconv$Proportions)[1],]
expWSAF = t(PG0390CoverageVcf.deconv$Haps) \%*\% prop
plotObsExpWSAF(obsWSAF, expWSAF)

}

