% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dEploidPlotly.R
\name{plotHistWSAFPlotly}
\alias{plotHistWSAFPlotly}
\title{WSAF histogram}
\usage{
plotHistWSAFPlotly(obsWSAF, exclusive = TRUE, title = "Histogram 0<WSAF<1")
}
\arguments{
\item{obsWSAF}{Observed allele frequency within sample}

\item{exclusive}{When TRUE 0 < WSAF < 1; otherwise 0 <= WSAF <= 1.}

\item{title}{Figure title, "Histogram 0<WSAF<1" by default}
}
\value{
histogram
}
\description{
Produce histogram of the allele frequency within sample.
}
\examples{
# Example 1
refFile = system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile = system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390Coverage = extractCoverageFromTxt(refFile, altFile)
obsWSAF = computeObsWSAF(PG0390Coverage$altCount, PG0390Coverage$refCount)
plotHistWSAFPlotly(obsWSAF)
myhist = plotHistWSAFPlotly(obsWSAF)

# Example 2
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV = extractCoverageFromVcf(vcfFile)
obsWSAF = computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)
plotHistWSAFPlotly(obsWSAF)
myhist = plotHistWSAFPlotly(obsWSAF)

}
