% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustPVals.R
\name{adjustPVals}
\alias{adjustPVals}
\title{Adjusts a numeric vector of p-values.}
\usage{
adjustPVals(pVals, adjust = "none", plotFdr = FALSE, verbose = FALSE)
}
\arguments{
\item{pVals}{Numeric vector of p-values to adjust.}

\item{adjust}{Allows for resulting p-values to be corrected for multiple hypothesis tests. Optional and some non-default choices require the "fdrtool" package. Default = "none", which means that no p-value adjustment is performed. Other options include methods in ?p.adjust (i.e., "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr"), and methods in ?fdrtool (i.e., "fndr", "pct0", "locfdr").}

\item{plotFdr}{Allows for plotting of fdrtool p-value adjustment result, if this is chosen. Requires fdrtool package. Default = FALSE.}

\item{verbose}{If TRUE, the function prints out the general method used for multiple correction analysis. Default = FALSE.}
}
\value{
A numeric vector of p-values that have been adjusted according to the specified method.
}
\description{
Wraps around the R base implementation of p.adjust, as well as the methods used in the fdr tool package.
}
\examples{
pvals = runif(100, 0, 1)
adj_pvals_bh = adjustPVals(pvals, adjust = "BH")
adj_pvals_hommel = adjustPVals(pvals, adjust = "hommel")
}

