% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateResiduals.R
\name{checkModel}
\alias{checkModel}
\title{Check if the fitted model is supported by DHARMa}
\usage{
checkModel(fittedModel, stop = F)
}
\arguments{
\item{fittedModel}{a fitted model}

\item{stop}{whether to throw an error if the model is not supported by DHARMa}
}
\description{
The function checks if the fitted model is supported by DHARMa, and if there are other issues, for example the use of weights, that could create problems for calculating quantile residuals
}
\details{
The main purpose of this function os to check if the fitted model class is supported by DHARMa. The function additionally checks for properties of the fitted model that could create problems for calculating residuals or working with the resuls in DHARMa. At the moment, two such issues are checked

1) Use of weights: most regression models in R support the use of the weights argument. Unfortunately, the argument means different things, depending on the context. In many situations, weights basically reweights the likelihood. In this case, simulated quantile residuals cannot be used, because the weighting

2) NA values in the data: checkModel will detect if there were NA values in the data frame. For NA values, most regression models will remove the entire observation from the data. This is not a problem for DHARMa - residuals are then only calculated for non-NA rows in the data. However, if you provide additional predictors to DHARMa, for example to plot residuals against a predictor, you will have to remove all NA rows that were also removed in the model, otherwise the lengths of the vectors will not match.
}
\keyword{internal}
