% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.DIFtree.R
\name{plot.DIFtree}
\alias{plot.DIFtree}
\title{Plotting Item focussed Trees}
\usage{
\method{plot}{DIFtree}(x, item, cex.lines = 2, cex.main = 1,
  cex.branches = 1, cex.coefs = 1, title = NULL, ...)
}
\arguments{
\item{x}{object of class \code{\link[DIFtree]{DIFtree}}}

\item{item}{number of the item, for which the tree shall be plotted}

\item{cex.lines}{line width of lines of the tree}

\item{cex.main}{size of the title of the tree}

\item{cex.branches}{size of labeling of branches of the tree}

\item{cex.coefs}{size of coefficients in the terminal nodes of the tree}

\item{title}{optional title, which is added to the tree,
if \code{title=NULL} the title is the number of the plotted item.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Visualization of trees for items with DIF identified by item focussed recursive partitioning.
}
\examples{
data(data_sim)

Y <- data_sim[,1]
X <- data_sim[,-1]

\dontrun{

mod <- DIFtree(Y=Y,X=X,alpha=0.05,nperm=100,trace=TRUE)

plot(mod,item=1)
}
}
\author{
Moritz Berger <moritz.berger@stat.uni-muenchen.de> \cr \url{http://www.statistik.lmu.de/~mberger/}
}
\references{
Tutz, Gerhard and Berger, Moritz (2015): Item Focused Trees for the Identification of Items
in Differential Item Functioning, Department of Statistics, LMU Munich
}
\seealso{
\code{\link[DIFtree]{DIFtree}}, \code{\link[DIFtree]{predict.DIFtree}}
}

