% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-FindOutliers.R
\name{FindOutliers}
\alias{FindOutliers}
\alias{FindOutliers,DISCBIO-method}
\title{Inference of outlier cells}
\usage{
FindOutliers(
  object,
  K,
  outminc = 5,
  outlg = 2,
  probthr = 0.001,
  thr = 2^-(1:40),
  outdistquant = 0.75,
  plot = TRUE,
  quiet = FALSE
)

\S4method{FindOutliers}{DISCBIO}(
  object,
  K,
  outminc = 5,
  outlg = 2,
  probthr = 0.001,
  thr = 2^-(1:40),
  outdistquant = 0.75,
  plot = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{K}{Number of clusters to be used.}

\item{outminc}{minimal transcript count of a gene in a clusters to be tested
for being an outlier gene. Default is 5.}

\item{outlg}{Minimum number of outlier genes required for being an outlier
cell. Default is 2.}

\item{probthr}{outlier probability threshold for a minimum of \code{outlg}
genes to be an outlier cell. This probability is computed from a negative
binomial background model of expression in a cluster. Default is 0.001.}

\item{thr}{probability values for which the number of outliers is computed in
order to plot the dependence of the number of outliers on the probability
threshold. Default is 2**-(1:40).set}

\item{outdistquant}{Real number between zero and one. Outlier cells are
merged to outlier clusters if their distance smaller than the
outdistquant-quantile of the distance distribution of  pairs of cells in
the orginal clusters after outlier removal. Default is 0.75.}

\item{plot}{if `TRUE`, produces a plot of -log10prob per K}

\item{quiet}{if `TRUE`, intermediary output is suppressed}
}
\value{
A named vector of the genes containing outlying cells and the number
  of cells on each.
}
\description{
This functions performs the outlier identification for k-means and model-based clustering
}
\examples{
sc <- DISCBIO(valuesG1msTest)
sc <- Clustexp(sc, cln=2) # K-means clustering
FindOutliers(sc, K=2)

}
