% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Output.r
\name{DBSRA}
\alias{DBSRA}
\title{Depletion-Based Stock Reduction Analysis}
\usage{
DBSRA(x, Data, reps = 100)
}
\arguments{
\item{x}{A position in a data-limited methods object.}

\item{Data}{A data-limited methods object.}

\item{reps}{The number of samples of the TAC (OFL) recommendation.}
}
\value{
A vector of TAC (OFL) values.
}
\description{
User prescribed BMSY/B0, M, FMSY/M are used to find B0 and therefore the OFL
by back-constructing the stock to match a user specified level of stock
depletion (OFL = M * FMSY/M * depletion* B0).
}
\details{
You specify a range of stock depletion and, given historical catches DB-SRA
calculates what unfished biomass must have been to get you here given
samples for M, FMSY relative to M and also BMSY relative to Bunfished.
}
\note{
This is set up to return the OFL (FMSY * current biomass).

You may have noticed that you -the user- specify three of the factors that
make the quota recommendation. So this can be quite a subjective method.

Also the DB-SRA method of this package isn't exactly the same as the
original method of Dick and MacCall (2011) because it has to work for
simulated depletions above BMSY/B0 and even on occasion over B0. Also it
doesn't have the modification for flatfish life histories that has
previously been applied by Dick and MacCall.
}
\references{
Dick, E.J., MacCall, A.D., 2011. Depletion-Based Stock Reduction
Analysis: A catch-based method for determining sustainable yields for
data-poor fish stocks. Fish. Res. 110, 331-341.
}
\author{
T. Carruthers
}
