% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMinit_doc.R
\name{OMinit}
\alias{OMinit}
\title{Initialize Operating Model}
\usage{
OMinit(name = NULL, ..., files = c("xlsx", "rmd"), overwrite = FALSE)
}
\arguments{
\item{name}{The name of the Excel and source.rmd file to be created in the working directory (character). 
Use 'example' for a populated example OM XL and documentation file.}

\item{...}{Optional DLMtool objects to use as templates: OM, Stock, Fleet, Obs, or Imp objects}

\item{files}{What files should be created: 'xlsx', 'rmd', or c('xlsx', 'rmd') (default: both)
to use as templates for the Operating Model.}

\item{overwrite}{Logical. Should files be overwritten if they already exist?}
}
\value{
name.xlsx and name_source.rmd files are created in the working directory.
}
\description{
Generates an Excel spreadsheet and a source.rmd file in the current working directory for 
specifying and documenting a DLMtool Operating Model.
}
\examples{
\dontrun{
# Create an Excel OM template and rmd file called 'myOM.xlsx' and 'myOM_source.rmd': 
OMinit('myOM')

# Create an Excel OM template and text file called 'myOM.rmd' and 'myOM_source.rmd', using
another OM as a template: 
OMinit('myOM', myOM)

# Create an Excel OM template and text file called 'myOM.rmd' and 'myOM_source.rmd', using
the Stock object 'Herring' as a template: 
OMinit('myOM', Herring)

# Create an Excel OM template and text file called 'myOM.rmd' and 'myOM_source.rmd', using
the Stock object 'Herring', and Obs object 'Generic_obs' as templates: 
OMinit('myOM', Herring, Generic_obs)
}

}
\author{
A. Hordyk
}
