% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StochasticSRA.R
\name{LSRA}
\alias{LSRA}
\title{Estimates R0 using SRA to match current F estimates and avoid penalities for low stock sizes}
\usage{
LSRA(x, FF, Chist_arr, M, Mat_age, Wt_age, sel, Recdevs, h)
}
\arguments{
\item{x}{a position in the various arrays and vectors that corresponds with a simulation (for use with sapply)}

\item{FF}{a vector of recent fishign mortality rates (apical Fs)}

\item{Chist_arr}{a vector of historical catch observations \code{[nyears]}}

\item{M}{a vector of natural mortality rates \code{[nsim]}}

\item{Mat_age}{a matrix of maturity at age \code{[nsim x nage]}}

\item{Wt_age}{a matrix of weight at age \code{[nsim x nage]}}

\item{sel}{a matrix of selectivity at age \code{[nsim x nage]}}

\item{Recdevs}{a matrix of recruitment deviations \code{[nsim x nyears]}}

\item{h}{a vector of steepness values of the Bev-Holt Stock-Recruitment relationship}
}
\value{
all package data objects are placed in the global namespace \code{dir}
}
\description{
Estimates R0 using SRA to match current F estimates and avoid penalities for low stock sizes
}
\author{
T. Carruthers
}
