% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{getq3}
\alias{getq3}
\title{optimize for catchability (q)}
\usage{
getq3(x, D, SSB0, nareas, maxage, N, pyears, M_ageArray, Mat_age, Asize,
  Wt_age, V, retA, Perr, mov, SRrel, Find, Spat_targ, hs, R0a, SSBpR, aR,
  bR, bounds = c(1e-05, 15), maxF, MPA, useCPP = TRUE)
}
\arguments{
\item{x}{Integer, the simulation number}

\item{D}{A numeric vector nsim long of sampled depletion}

\item{SSB0}{A numeric vector nsim long of total unfished spawning biomass}

\item{nareas}{The number of spatial areas}

\item{maxage}{The maximum age}

\item{N}{Array of the numbers-at-age in population. Dimensions are nsim, maxage, nyears, nareas.
Only values from the first year (i.e \code{N[,,1,]}) are used, which is the current N-at-age.}

\item{pyears}{The number of years to project forward. Equal to 'nyears' for optimizing for q.}

\item{M_ageArray}{An array (dimensions nsim, maxage, nyears+proyears) with the natural mortality-at-age and year}

\item{Mat_age}{An array (dimensions nsim, maxage, proyears+nyears) with the proportion mature for each age-class}

\item{Asize}{A matrix (dimensions nsim, nareas) with size of each area}

\item{Wt_age}{An array (dimensions nsim, maxage, nyears+proyears) with the weight-at-age and year}

\item{V}{An array (dimensions nsim, maxage, nyears+proyears) with the vulnerability-at-age and year}

\item{retA}{An array (dimensions nsim, maxage, nyears+proyears) with the probability retained-at-age and year}

\item{Perr}{A matrix (dimensions nsim, nyears+proyears) with the recruitment deviations}

\item{mov}{An array (dimensions nsim, nareas, nareas, nyears+proyears) with the movement matrix}

\item{SRrel}{A numeric vector nsim long specifying the recruitment curve to use}

\item{Find}{A matrix (dimensions nsim, nyears) with the historical fishing effort}

\item{Spat_targ}{A numeric vector nsim long with the spatial targeting}

\item{hs}{A numeric vector nsim long with the steepness values for each simulation}

\item{R0a}{A matrix (dimensions nsim, nareas) with the unfished recruitment by area}

\item{SSBpR}{A matrix (dimensions nsim, nareas) with the unfished spawning-per-recruit by area}

\item{aR}{A numeric vector nareas long with the Ricker SRR a values}

\item{bR}{A numeric vector nareas long with the Ricker SRR b values}

\item{bounds}{A numeric vector of length 2 with bounds for the optimizer}

\item{maxF}{A numeric value specifying the maximum fishing mortality for any single age class}

\item{MPA}{A matrix of spatial closures by year}

\item{useCPP}{logical - use the CPP code? For testing purposes only}
}
\description{
Function optimizes catchability (q, where F=qE) required to get to user-specified stock
depletion
}
\author{
A. Hordyk
}
\keyword{internal}
