# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Internal estimation function for LBSPR MP
#'
#' @param SL50 Length at 50 percent selectivity
#' @param SL95 Length at 95 percent selectivity
#' @param FM Ratio of apical fishing mortality to natural mortality
#' @param nage Number of pseudo age-classes
#' @param nlen Number of length bins
#' @param CVLinf CV of length-at-age
#' @param LenBins Vector of length bins
#' @param LenMids Vector of mid-points of length bins
#' @param MK Ratio of M/K
#' @param Linf Asymptotic length
#' @param rLens Vector of relative length at ate
#' @param Prob ALK 
#' @param Ml Maturity at age vector
#' @param L50 Length at 50 percent maturity
#' @param L95 Length at 95 percent maturity
#' @param Beta Exponent of the length-weight relationship
#' @author A. Hordyk
#' @useDynLib DLMtool
#' @keywords internal
#' @export
LBSPRgen <- function(SL50, SL95, FM, nage, nlen, CVLinf, LenBins, LenMids, MK, Linf, rLens, Prob, Ml, L50, L95, Beta) {
    .Call('_DLMtool_LBSPRgen', PACKAGE = 'DLMtool', SL50, SL95, FM, nage, nlen, CVLinf, LenBins, LenMids, MK, Linf, rLens, Prob, Ml, L50, L95, Beta)
}

LBSPRopt <- function(pars, CAL, nage, nlen, CVLinf, LenBins, LenMids, MK, Linf, rLens, Prob, Ml, L50, L95, Beta) {
    .Call('_DLMtool_LBSPRopt', PACKAGE = 'DLMtool', pars, CAL, nage, nlen, CVLinf, LenBins, LenMids, MK, Linf, rLens, Prob, Ml, L50, L95, Beta)
}

#' Internal estimation function for LSRA and LSRA2 functions
#'
#' Rcpp version of R code 
#' @param param a numeric value representing log(R0)
#' @param FF_a numeric value, recent fishign mortality rate (apical F)
#' @param Chist a vector of historical catch observations `[nyears]`
#' @param M_a numeric value, natural mortality rate
#' @param Mat_age_a a vector of maturity at age `[nage]`
#' @param Wt_age_a a vector of weight at age `[nage]`
#' @param sel_a a vector of selectivity at age `[nage]`
#' @param Recdevs_a a vector of recruitment deviations `[nyears]`
#' @param h_a a numeric value of steepness values of the Bev-Holt Stock-Recruitment relationship
#' @param Umax maximum harvest rate per year
#' @author T. Carruthers with an amateur attempt at converting to Rcpp by A. Hordyk (but it works!)
#' @useDynLib DLMtool
#' @keywords internal
#' @export
LSRA_opt_cpp <- function(param, FF_a, Chist, M_a, Mat_age_a, Wt_age_a, sel_a, Recdevs_a, h_a, Umax) {
    .Call('_DLMtool_LSRA_opt_cpp', PACKAGE = 'DLMtool', param, FF_a, Chist, M_a, Mat_age_a, Wt_age_a, sel_a, Recdevs_a, h_a, Umax)
}

#' Internal SRA MCMC CPP code
#'
#' Rcpp version of R code 
#' @param nits number of iterations
#' @param pars vector of parameters
#' @param JumpCV jump cv vector
#' @param adapt adapt vector
#' @param parLB lower bounds
#' @param parUB upper bounds
#' @param R0ind index for R0
#' @param inflind index for inflection
#' @param slpind index for slope
#' @param RDind index for recruitment deviations
#' @param nyears number of projection years
#' @param maxage maximum age
#' @param M Natural mortality
#' @param Mat_age A vector of maturity at age 
#' @param Wt_age A vector of weight at age 
#' @param Chist_a A vector of historical catch observations (nyears long) going back to unfished conditions
#' @param Umax A numeric value representing the maximum harvest rate for any age class (rejection of sims where this occurs)
#' @param h steepness of SRR
#' @param CAA A matrix nyears (rows) by nages (columns) of catch at age (age 1 to maxage in length)
#' @param CAAadj internal parameter
#' @param sigmaR A numeric value representing the prior standard deviation of log space recruitment deviations
#' 
#' @author A. Hordyk
#' @export
LSRA_MCMC_sim <- function(nits, pars, JumpCV, adapt, parLB, parUB, R0ind, inflind, slpind, RDind, nyears, maxage, M, Mat_age, Wt_age, Chist_a, Umax, h, CAA, CAAadj, sigmaR) {
    .Call('_DLMtool_LSRA_MCMC_sim', PACKAGE = 'DLMtool', nits, pars, JumpCV, adapt, parLB, parUB, R0ind, inflind, slpind, RDind, nyears, maxage, M, Mat_age, Wt_age, Chist_a, Umax, h, CAA, CAAadj, sigmaR)
}

bhnoneq_LL <- function(stpar, year, Lbar, ss, Linf, K, Lc, nbreaks) {
    .Call('_DLMtool_bhnoneq_LL', PACKAGE = 'DLMtool', stpar, year, Lbar, ss, Linf, K, Lc, nbreaks)
}

combine <- function(list) {
    .Call('_DLMtool_combine', PACKAGE = 'DLMtool', list)
}

get_freq <- function(x, width, origin = 0, outlen = 0L) {
    .Call('_DLMtool_get_freq', PACKAGE = 'DLMtool', x, width, origin, outlen)
}

which_maxC <- function(x) {
    .Call('_DLMtool_which_maxC', PACKAGE = 'DLMtool', x)
}

rnormSelect2 <- function(N, mi, ma) {
    .Call('_DLMtool_rnormSelect2', PACKAGE = 'DLMtool', N, mi, ma)
}

tdnorm <- function(x, mi, ma) {
    .Call('_DLMtool_tdnorm', PACKAGE = 'DLMtool', x, mi, ma)
}

genSizeComp <- function(VulnN, CAL_binsmid, selCurve, CAL_ESS, CAL_nsamp, Linfs, Ks, t0s, LenCV, truncSD) {
    .Call('_DLMtool_genSizeComp', PACKAGE = 'DLMtool', VulnN, CAL_binsmid, selCurve, CAL_ESS, CAL_nsamp, Linfs, Ks, t0s, LenCV, truncSD)
}

#' Rcpp version of the Optimization function that returns the squared difference between user
#' specified and calculated movement parameters. 
#'
#' The user specifies the probability of staying in the same area and spatial
#' heterogeneity (both in the unfished state). This function returns the
#' squared difference between these values and those produced by the three
#' logit movement model.
#'
#' This is paired with getmov to find the correct movement model. 
#' 
#' @param par Three parameters in the logit space that control the four
#' probabilities of moving between 2 areas
#' @param prb User specified probability that individuals in area 1 remain in
#' that area (unfished conditions)
#' @param frac User specified fraction of individuals found in area 1 (unfished
#' conditions)
#' 
#' @author T. Carruthers with an amateur attempt at converting to Rcpp by A. Hordyk (but it works!)
#' @useDynLib DLMtool
#' @export
movfit_Rcpp <- function(par, prb, frac) {
    .Call('_DLMtool_movfit_Rcpp', PACKAGE = 'DLMtool', par, prb, frac)
}

#' Population dynamics model for one annual time-step
#'
#' Project population forward one time-step given current numbers-at-age and total mortality
#'
#' @param nareas The number of spatial areas
#' @param maxage The maximum age 
#' @param SSBcurr A numeric vector of length nareas with the current spawning biomass in each area
#' @param Ncurr A numeric matrix (maxage, nareas) with current numbers-at-age in each area
#' @param Zcurr A numeric matrix (maxage, nareas) with total mortality-at-age in each area
#' @param PerrYr A numeric value with recruitment deviation for current year 
#' @param hs Steepness of SRR
#' @param R0a Numeric vector with unfished recruitment by area
#' @param SSBpR Numeric vector with unfished spawning stock per recruit by area 
#' @param aR Numeric vector with Ricker SRR a parameter by area
#' @param bR Numeric vector with Ricker SRR b parameter by area
#' @param mov Numeric matrix (nareas by nareas) with the movement matrix
#' @param SRrel Integer indicating the stock-recruitment relationship to use (1 for Beverton-Holt, 2 for Ricker)
#' 
#' @author A. Hordyk
#' 
#' @export
#' @keywords internal
popdynOneTScpp <- function(nareas, maxage, SSBcurr, Ncurr, Zcurr, PerrYr, hs, R0a, SSBpR, aR, bR, mov, SRrel, plusgroup = 0L) {
    .Call('_DLMtool_popdynOneTScpp', PACKAGE = 'DLMtool', nareas, maxage, SSBcurr, Ncurr, Zcurr, PerrYr, hs, R0a, SSBpR, aR, bR, mov, SRrel, plusgroup)
}

#' Population dynamics model in CPP
#'
#' Project population forward pyears given current numbers-at-age and total mortality, etc 
#' for the future years
#'
#' @param nareas The number of spatial areas
#' @param maxage The maximum age 
#' @param SSBcurr A numeric vector of length nareas with the current spawning biomass in each area
#' @param Ncurr A numeric matrix (maxage, nareas) with current numbers-at-age in each area
#' @param pyears The number of years to project the population forward
#' @param M_age Numeric matrix (maxage, pyears) with natural mortality by age and year
#' @param Asize_c Numeric vector (length nareas) with size of each area
#' @param MatAge Numeric vector with proportion mature by age
#' @param WtAge Numeric matrix (maxage, pyears) with weight by age and year
#' @param Vuln Numeric matrix (maxage, pyears) with vulnerability by age and year
#' @param Retc Numeric matrix (maxage, pyears) with retention by age and year
#' @param Prec Numeric vector (pyears) with recruitment error
#' @param movc Numeric array (nareas by nareas) with the movement matrix
#' @param SRrelc Integer indicating the stock-recruitment relationship to use (1 for Beverton-Holt, 2 for Ricker)
#' @param Effind Numeric vector (length pyears) with the fishing effort by year
#' @param Spat_targc Integer. Spatial targetting
#' @param hc Numeric. Steepness of stock-recruit relationship
#' @param R0c Numeric vector of length nareas with unfished recruitment by area
#' @param SSBpRc Numeric vector of length nareas with unfished spawning per recruit by area
#' @param aRc Numeric. Ricker SRR a value by area
#' @param bRc Numeric. Ricker SRR b value by area
#' @param Qc Numeric. Catchability coefficient
#' @param Fapic Numeric. Apical F value
#' @param maxF A numeric value specifying the maximum fishing mortality for any single age class
#' @param MPA Spatial closure by year and area
#' @param control Integer. 1 to use q and effort to calculate F, 2 to use Fapic (apical F) and 
#' vulnerablity to calculate F.
#' @param plusgroup Integer. Include a plus-group (1) or not (0)?
#' 
#' @author A. Hordyk
#' @export
#' @keywords internal
popdynCPP <- function(nareas, maxage, Ncurr, pyears, M_age, Asize_c, MatAge, WtAge, Vuln, Retc, Prec, movc, SRrelc, Effind, Spat_targc, hc, R0c, SSBpRc, aRc, bRc, Qc, Fapic, maxF, MPA, control, SSB0c, plusgroup = 0L) {
    .Call('_DLMtool_popdynCPP', PACKAGE = 'DLMtool', nareas, maxage, Ncurr, pyears, M_age, Asize_c, MatAge, WtAge, Vuln, Retc, Prec, movc, SRrelc, Effind, Spat_targc, hc, R0c, SSBpRc, aRc, bRc, Qc, Fapic, maxF, MPA, control, SSB0c, plusgroup)
}

