% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DLSSM.R
\name{DLSSM}
\alias{DLSSM}
\title{Combine model training and validation in a integrated function}
\usage{
DLSSM(data.batched, S0, vary.effects, autotune = TRUE, Lambda = NULL, K)
}
\arguments{
\item{data.batched}{A object generated by function Data.batched()}

\item{S0}{Number of batches of data to be used as training dataset}

\item{vary.effects}{The names of variables in the dataset assumed to have a time-varying regression effect on the outcome.}

\item{autotune}{T/F indicates whether or not the automatic tuning procedure desribed in Jiakun et al. (2021) should be applied.  Default is true.}

\item{Lambda}{Specify smoothing parameters if autotune=F}

\item{K}{Number of steps for ahead prediction}
}
\value{
\tabular{ll}{
   \code{Lambda:} \tab smoothing parameters \cr
   \tab \cr
   \code{Smooth:} \tab smoothed state vector \cr
   \tab \cr
   \code{Smooth.var:} \tab covariance of smoothed state vector in Smooth.  \cr
 }
}
\description{
This combine model training and validation in a integrated automatic function DLSSM().
}
\examples{
 \donttest{
set.seed(321)
n=8000
beta0=function(t)   0.1*t-1
beta1=function(t)  cos(2*pi*t)
beta2=function(t)  sin(2*pi*t)
alph1=alph2=1
x=matrix(runif(n*4,min=-4,max=4),nrow=n,ncol=4)
t=sort(runif(n))
coef=cbind(beta0(t),beta1(t),beta2(t),rep(alph1,n),rep(alph2,n))
covar=cbind(rep(1,n),x)
linear=apply(coef*covar,1,sum)
prob=exp(linear)/(1+exp(linear))
y=as.numeric(runif(n)<prob)
sim.data=cbind(y,x,t)
colnames(sim.data)=c("y","x1","x2","x3","x4","t")
formula = y~x1+x2+x3+x4
# Divide the time domain [0,1] into S=100 equally spaced intervals
S=100
S0=75
data.batched=Batched(formula, data=sim.data, time="t", S)

# Take first S0=75 batches as training data, remaining S-S0=25 batches of data as validation data.
 fit1=DLSSM(data.batched, S0, vary.effects=c("x1","x2"), autotune=TRUE, Lambda=NULL, K=1)
 DLSSM.plot(fit1)
 fit2=DLSSM(data.batched, S0, vary.effects=c("x1","x2"), autotune=TRUE, Lambda=NULL, K=2)
 DLSSM.plot(fit2)
 }
}
\author{
Jiakun Jiang, Wei Yang and Wensheng Guo
}
