% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcData.R
\name{calculateCAF}
\alias{calculateCAF}
\title{calculateCAF}
\usage{
calculateCAF(
  dat,
  nCAF = 5,
  columns = c("Subject", "Comp", "RT", "Error"),
  compCoding = c("comp", "incomp"),
  errorCoding = c(0, 1)
)
}
\arguments{
\item{dat}{DataFrame with columns containing the participant number, condition
compatibility, RT data (in ms) and an Error column.}

\item{nCAF}{Number of CAF bins.}

\item{columns}{Name of required columns Default: c("Subject", "Comp", "RT", "Error")}

\item{compCoding}{Coding for compatibility Default: c("comp", "incomp")}

\item{errorCoding}{Coding for errors Default: c(0, 1))}
}
\value{
calculateCAF returns a DataFrame with conditional accuracy function (CAF) data (Bin, comp, incomp, effect)
}
\description{
Calculate conditional accuracy function (CAF).
The DataFrame should contain columns defining the participant, compatibility condition,
RT and error (Default column names: "Subject", "Comp", "RT", "Error"). The "Comp" column should
define compatibility condition (Default: c("comp", "incomp")) and the "Error" column should
define if the trial was an error or not (Default: c(0, 1) ).
}
\examples{
# Example 1
dat <- createDF(nSubjects = 1, nTrl = 10000, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
                 RT = list("Comp_comp"   = c(500, 80, 100),
                           "Comp_incomp" = c(600, 80, 140)),
                 Error = list("Comp_comp"   = c( 5, 4, 3, 2, 1),
                              "Comp_incomp" = c(20, 8, 6, 4, 2)))
caf <- calculateCAF(dat)

# Example 2
dat <- createDF(nSubjects = 1, nTrl = 10000, design = list("Congruency" = c("cong", "incong")))
dat <- addDataDF(dat,
                 RT = list("Congruency_cong"   = c(500, 80, 100),
                           "Congruency_incong" = c(600, 80, 140)),
                 Error = list("Congruency_cong"   = c( 5, 4, 3, 2, 1),
                              "Congruency_incong" = c(20, 8, 6, 4, 2)))
head(dat)
caf <- calculateCAF(dat, columns = c("Subject", "Congruency", "RT", "Error"),
                    compCoding = c("cong", "incong"))


}
