% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{DPI_curve}
\alias{DPI_curve}
\title{DPI curve analysis across multiple random covariates.}
\usage{
DPI_curve(
  model,
  x,
  y,
  data = NULL,
  k.covs = 1:10,
  n.sim = 1000,
  alpha = 0.05,
  bonf = FALSE,
  pseudoBF = FALSE,
  seed = NULL,
  progress,
  file = NULL,
  width = 6,
  height = 4,
  dpi = 500
)
}
\arguments{
\item{model}{Model object (\code{lm}).}

\item{x}{Independent (predictor) variable.}

\item{y}{Dependent (outcome) variable.}

\item{data}{[Optional] Defaults to \code{NULL}. If \code{data} is specified, then \code{model} will be ignored and a linear model \code{lm({y} ~ {x} + .)} will be fitted inside. This is helpful for exploring all variables in a dataset.}

\item{k.covs}{An integer vector of number of random covariates (simulating potential omitted variables) added to each simulation sample. Defaults to \code{1:10} (producing DPI results for \code{k.cov}=1~10). For details, see \code{\link[=DPI]{DPI()}}.}

\item{n.sim}{Number of simulation samples. Defaults to \code{1000}.}

\item{alpha}{Significance level for computing the \code{Significance} score (0~1) based on \emph{p} value of partial correlation between \code{X} and \code{Y}. Defaults to \code{0.05}.
\itemize{
\item \code{Direction = R2.Y - R2.X}
\item \code{Significance = 1 - tanh(p.beta.xy/alpha/2)}
}}

\item{bonf}{Bonferroni correction to control for false positive rates: \code{alpha} is divided by, and \emph{p} values are multiplied by, the number of comparisons.
\itemize{
\item Defaults to \code{FALSE}: No correction, suitable if you plan to test only one pair of variables.
\item \code{TRUE}: Using \code{k * (k - 1) / 2} (all pairs of variables) where \code{k = length(data)}.
\item A user-specified number of comparisons.
}}

\item{pseudoBF}{Use normalized pseudo Bayes Factors \code{sigmoid(log(PseudoBF10))} alternatively as the \code{Significance} score (0~1). Pseudo Bayes Factors are computed from \emph{p} value of X-Y partial relationship and total sample size, using the transformation rules proposed by Wagenmakers (2022) \doi{10.31234/osf.io/egydq}.

Defaults to \code{FALSE} because it makes less penalties for insignificant partial relationships between \code{X} and \code{Y}, see Examples in \code{\link[=DPI]{DPI()}} and \href{https://psychbruce.github.io/DPI/#step-2-normalized-penalty-as-significance-score}{online documentation}.}

\item{seed}{Random seed for replicable results. Defaults to \code{NULL}.}

\item{progress}{Show progress bar. Defaults to \code{TRUE} (if \code{length(k.covs)} >= 5).}

\item{file}{File name of saved plot (\code{".png"} or \code{".pdf"}).}

\item{width, height}{Width and height (in inches) of saved plot. Defaults to \code{6} and \code{4}.}

\item{dpi}{Dots per inch (figure resolution). Defaults to \code{500}.}
}
\value{
Return a data.frame of DPI curve results.
}
\description{
DPI curve analysis across multiple random covariates.
}
\examples{
\donttest{model = lm(Ozone ~ ., data=airquality)
DPIs = DPI_curve(model, x="Solar.R", y="Ozone", seed=1)
plot(DPIs)  # ggplot object
}
}
\seealso{
\link{S3method.dpi}

\code{\link[=DPI]{DPI()}}

\code{\link[=DPI_dag]{DPI_dag()}}

\code{\link[=BNs_dag]{BNs_dag()}}

\code{\link[=cor_net]{cor_net()}}

\code{\link[=p_to_bf]{p_to_bf()}}
}
