% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{DPI_curve}
\alias{DPI_curve}
\title{The DPI curve analysis.}
\usage{
DPI_curve(
  model,
  y,
  x,
  data = NULL,
  k.covs = 1:10,
  n.sim = 1000,
  seed = NULL,
  file = NULL,
  width = 6,
  height = 4,
  dpi = 500
)
}
\arguments{
\item{model}{Model object (\code{lm}).}

\item{y}{Dependent (outcome) variable.}

\item{x}{Independent (predictor) variable.}

\item{data}{[Optional] Defaults to \code{NULL}.
If \code{data} is specified, then \code{model} will be ignored and
a linear model \code{lm({y} ~ {x} + .)} will be fitted inside.
This is helpful for exploring all variables in a dataset.}

\item{k.covs}{An integer vector of number of random covariates
(simulating potential omitted variables)
added to each simulation sample.
Defaults to \code{1:10} (producing DPI results for \code{k.cov}=1~10).
For details, see \code{\link{DPI}}.}

\item{n.sim}{Number of simulation samples.
Defaults to \code{1000}.}

\item{seed}{Random seed for replicable results.
Defaults to \code{NULL}.}

\item{file}{File name of saved plot (\code{".png"} or \code{".pdf"}).}

\item{width, height}{Width and height (in inches) of saved plot.
Defaults to \code{6} and \code{4}.}

\item{dpi}{Dots per inch (figure resolution). Defaults to \code{500}.}
}
\value{
Return a data.frame of DPI curve results.
}
\description{
The DPI curve analysis.
}
\examples{
\donttest{model = lm(Ozone ~ ., data=airquality)
DPIs = DPI_curve(model, y="Ozone", x="Solar.R", seed=1)
plot(DPIs)  # ggplot object
}
}
