% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drhot.R
\name{drhot}
\alias{drhot}
\title{Identifies differential risk hotspots along a linear network given a vector of relative probabilities computed over the middle points of the segments of the network}
\usage{
drhot(X, rel_probs, k, n, dist = "path", event_distances = NULL)
}
\arguments{
\item{X}{- A \code{lpp} object representing a marked point pattern lying on a road network (\code{linnet} object)}

\item{rel_probs}{- An object containing the relative probabilities of a specific type of event along the linear network contained in \code{X}, generated through the function \code{relpnet}}

\item{k}{- A numeric value that controls the procedure of detecting differential risk hotspots (departure from average relative probability), as described above}

\item{n}{- A numeric value that controls the procedure of detecting differential risk hotspots (minimum size for the sample of events implicated in the computation of the relative probabilities), as described above}

\item{dist}{- A character indicating which distance to use. Two values are allowed: \code{path} (shortest-path distance) and \code{euclidean} (Euclidean distance). By default, the shortest-path distance is used. Change to \code{euclidean} to reduce the computation time or skip memory issues}

\item{event_distances}{- A matrix that contains the distances between the middle points of the segments satisfying the condition on parameter \code{k} and the events o \code{X}. By default it is set to \code{NULL}}
}
\value{
Returns a list that contains the differential risk hotspots found for \code{X} and the type of event specified by \code{rel_probs}
}
\description{
Given a relative probability surface corresponding to the occurrence of a type of event along a linear network, this function filters and groups in hotspots those segments satisfying two conditions: 1) the relative probability in the segment exceeds the average relative probability per segment in \code{k} times the standard deviation of the complete set of probabilities estimated across all the segments of the network, and 2) there are \code{n} or more events at a distance below \code{h} from the middle point of the segment (\code{h} is obtained from the object \code{rel_probs} computed with the function \code{relpnet}). In summary, \code{k} and \code{n} control the formation of differential risk hotspots along the network, given a set of relative probabilities covering the network. The choice of a higher value for \code{k} or \code{n} (or both) represents a more strict criterion and leads to a lower number of differential risk hotspots being detected. Users should test several values of \code{k} and \code{n} (sensitivity analysis on \code{k} and \code{n}) in order to reach reasonable choices for the research or practical purposes of their data analyses. This sensitivity analysis can be carried out with the \code{drsens} function
}
\examples{
library(DRHotNet)
library(spatstat.core)
library(spatstat.geom)
library(spatstat.linnet)
library(spdep)
library(raster)
library(maptools)
\donttest{
rel_probs_rear_end <- relpnet(X = SampleMarkedPattern, 
lixel_length = 50, h = 100, mark = "Collision", category_mark = "Rear-end")
hotspots_rear_end <- drhot(X = SampleMarkedPattern, rel_probs = rel_probs_rear_end, 
k = 1, n = 30)
}
}
\references{
Briz-Redon, A., Martinez-Ruiz, F., & Montes, F. (2019). Identification of differential risk hotspots for collision and vehicle type in a directed linear network. Accident Analysis & Prevention, 132, 105278.
}
