% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_basicvirus.R
\name{simulate_basicvirus}
\alias{simulate_basicvirus}
\title{Simulation of a basic viral infection model without an immune response}
\usage{
simulate_basicvirus(U0 = 1e+07, I0 = 0, V0 = 1, tmax = 30, n = 0,
  dU = 0, dI = 1, dV = 2, b = 2e-07, p = 5, g = 1)
}
\arguments{
\item{U0}{initial number of uninfected target cells}

\item{I0}{initial number of infected target cells}

\item{V0}{initial number of infectious virions}

\item{tmax}{maximum simulation time, units depend on choice of units for parameters}

\item{n}{rate of new uninfected cell replenishment}

\item{dU}{rate at which uninfected cells die}

\item{dI}{rate at which infected cells die}

\item{dV}{rate at which infectious virus is cleared}

\item{b}{rate at which virus infects cells}

\item{p}{rate at which infected cells produce virus}

\item{g}{possible conversion factor for virus units}
}
\value{
A list. The list has only one element called ts.
ts contains the time-series of the simulation.
The 1st column of ts is Time, the other columns are the model variables.
}
\description{
This function runs a simulation of a 3 compartment model
using a set of ordinary differential equations.
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
The function returns a matrix containing time-series of each variable and time.
}
\details{
A simple compartmental model is simulated as a set of ordinary differential
equations, using an ode solver from the deSolve package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values,
  the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_basicvirus()
# To choose parameter values other than the standard one, specify the, like such:
result <- simulate_basicvirus(V0 = 100, tmax = 100, n = 1e5, dU = 1e-2)
# You should then use the simulation result returned from the function, e.g. like this:
plot(result$ts[,"Time"],result$ts[,"V"],xlab='Time',ylab='Virus',type='l',log='y')
}
\seealso{
See the Shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the deSolve
package for details on the underlying ODE simulator algorithm.
}
\author{
Andreas Handel
}
