% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_fitconfint.R
\name{simulate_fitconfint}
\alias{simulate_fitconfint}
\title{Fitting a simple viral infection models to influenza data}
\usage{
simulate_fitconfint(U0 = 1e+05, I0 = 0, V0 = 10, n = 0, dU = 0,
  dI = 2, p = 0.01, g = 0, b = 0.01, blow = 1e-06,
  bhigh = 1000, dV = 2, dVlow = 0.001, dVhigh = 1000,
  parscale = "lin", iter = 20, nsample = 10, rngseed = 100)
}
\arguments{
\item{U0}{initial number of uninfected target cells}

\item{I0}{initial number of infected target cells}

\item{V0}{initial number of infectious virions}

\item{n}{rate of uninfected cell production}

\item{dU}{rate at which uninfected cells die}

\item{dI}{rate at which infected cells die}

\item{p}{rate at which infected cells produce virus}

\item{g}{unit conversion factor}

\item{b}{rate at which virus infects cells}

\item{blow}{lower bound for infection rate}

\item{bhigh}{upper bound for infection rate}

\item{dV}{rate at which infectious virus is cleared}

\item{dVlow}{lower bound for virus clearance rate}

\item{dVhigh}{upper bound for virus clearance rate}

\item{parscale}{'lin' or 'log' to fit parameters in linear or log space}

\item{iter}{max number of steps to be taken by optimizer}

\item{nsample}{number of samples for conf int determination}

\item{rngseed}{seed for random number generator to allow reproducibility}
}
\value{
The function returns a list containing the best fit time series, the best fit parameters for
the data, the final SSR, and the bootstrapped confidence intervals.
}
\description{
This function runs a simulation of a compartment model
using a set of ordinary differential equations.
The model describes a simple viral infection system.
}
\details{
A simple compartmental ODE model mimicking acute viral infection
is fitted to data.
Data can either be real or created by running the model with known parameters and using the simulated data to
determine if the model parameters can be identified.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}

\examples{
# To run the code with default parameters just call the function:
\dontrun{result <- simulate_fitconfint()}
# To apply different settings, provide them to the simulator function, like such:
result <- simulate_fitconfint(iter = 5, nsample = 5)
}
\seealso{
See the Shiny app documentation corresponding to this
function for more details on this model.
}
\author{
Andreas Handel
}
