% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDSLiteData.R
\name{getDSLiteData}
\alias{getDSLiteData}
\title{Get data value from DSLite connection(s)}
\usage{
getDSLiteData(conns, symbol)
}
\arguments{
\item{conns}{\code{\link{DSConnection-class}} object or a list of \code{\link{DSConnection-class}}s.}

\item{symbol}{Symbol name identifying the variable in the \link{DSLiteServer}'s "server-side" environment(s).}
}
\value{
The data value or a list of values depending on the connections parameter. The value is NA when the connection object
is not of class \code{\link{DSLiteConnection-class}}.
}
\description{
Get the data value corresponding to the variable with the symbol name from the \link{DSLiteServer} associated
to the \code{\link{DSConnection-class}} object(s). Can be useful when developping a DataSHIELD package.
}
\examples{
{
# DataSHIELD login
logindata <- setupCNSIMTest()
conns <- datashield.login(logindata, assign=TRUE)
# retrieve symbol D value from each DataSHIELD connections
getDSLiteData(conns, "D")
# retrieve symbol D value from a specific DataSHIELD connection
getDSLiteData(conns$sim1, "D")
}

}
