% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalConnection.R
\name{dsHasTable,OpalConnection-method}
\alias{dsHasTable,OpalConnection-method}
\title{Verify Opal table}
\usage{
\S4method{dsHasTable}{OpalConnection}(conn, table)
}
\arguments{
\item{conn}{\code{\link{OpalConnection-class}} class object.}

\item{table}{The fully qualified name of the table.}
}
\value{
TRUE if table exists.
}
\description{
Verify Opal table exist and can be accessible for performing DataSHIELD operations.
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "username", "password", "https://opal.example.org")
dsHasTable(con, "test.CNSIM")
dsDisconnect(con)
}

}
