% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp2.R
\name{Chapter02}
\alias{Chapter02}
\alias{print_stats}
\alias{print_freqs}
\title{Chapter 2}
\usage{
print_stats(x, na.rm = TRUE)

print_freqs(x, breaks, include.lowest = TRUE, right = TRUE)
}
\arguments{
\item{x}{\link[base]{numeric} vector, the observations. 
In \link{print_freqs} function, this argument can also be a \link[base]{factor}}

\item{na.rm}{\link[base]{logical} scalar, whether to remove the missing observations (default \code{TRUE})}

\item{breaks}{\link[base]{numeric} vector, see \link[base]{cut.default}}

\item{include.lowest}{\link[base]{logical} scalar, default \code{TRUE}. See \link[base]{cut.default}}

\item{right}{\link[base]{logical} scalar, see \link[base]{cut.default}}
}
\value{
\link{print_freqs} returns a \linkS4class{freqs} object, for which
a \link[methods]{show} method, an \link[ggplot2]{autolayer} and an \link[ggplot2]{autoplot} method are defined.

\link{print_stats} does not have a returned value.
}
\description{
Functions and examples for Chapter 2, \emph{Descriptive Statistics}.
}
\details{
\link{print_freqs} prints the (relative) frequencies and cumulative (relative) frequencies, from 
a numeric input vector, specified interval breaks as well as open/close status of the ends of the intervals.

\link{print_stats} prints the simple statistics of the input observations, such as sample size,
mean, median, (smallest) mode, variance, standard deviation, 
coefficient of variation (if all observations are non-negative),
quartiles, inter-quartile range (IQR), range, skewness and kurtosis.  A histogram is also printed.
}
\examples{
library(DanielBiostatistics10th)

# Page 20, Example 2.2.1
d141 = read.csv(system.file('extdata', 'EXA_C01_S04_01.csv', package = 'DanielBiostatistics10th'))
head(d141)
class(d141$AGE) # 'integer'
class(age <- as.numeric(d141$AGE)) # 'numeric'
sort(age) # Page 21, Table 2.2.1 # 'ordered vector'

# Page 23, Example 2.3.1
(ageB = seq.int(from = 30, to = 90, by = 10))
(r231 = print_freqs(age, breaks = ageB, right = FALSE)) # Page 25, Table 2.3.2
# The open/close of interval ends is determined by textbook using 30-39, 40-49, etc.
autoplot(r231, title = 'Page 27, Figure 2.3.2')

# Page 38-42, Example 2.4.1 - Example 2.4.6
# Page 44-46, Example 2.5.1 - Example 2.5.3
print_stats(age) # or some other data input

# Page 49, Example 2.5.4 (omitted)

# Page 50, Example 2.5.5
d255 = read.csv(system.file('extdata', 'EXA_C02_S05_05.csv', package = 'DanielBiostatistics10th'))
head(d255)
boxplot(d255$GRF, main = c('GRF from Page 50, Example 2.5.5'))
print_stats(d255$GRF)
print_freqs(d255$GRF, breaks = seq.int(10, 45, by = 5))
}
\references{
Wayne W. Daniel, \emph{Biostatistics: A Foundation for Analysis in the Health Sciences}, Tenth Edition.
Wiley, ISBN: 978-1-119-62550-6.
}
\seealso{
\link[base]{cut.default} \link[base]{table} \link[base]{cumsum}
\link[base]{mean.default} \link[stats]{median.default} \link[pracma]{Mode} 
\link[stats]{var} \link[stats]{sd} \link[stats]{quantile}
\link[e1071]{skewness} \link[e1071]{kurtosis}
}
