% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BooleanTable.R
\docType{class}
\name{BooleanTable}
\alias{BooleanTable}
\alias{BooleanTable-class}
\title{\linkS4class{BooleanTable}: Boolean Test-&-Disease and/or Risk-&-Disease Table}
\usage{
BooleanTable(x)
}
\arguments{
\item{x}{two-by-two \link[base]{integer} \link[base]{matrix}, contingency table of two Boolean variables,
or an R object convertible to a two-by-two \link[base]{integer} \link[base]{matrix}.
The endpoint (i.e., disease) is on rows and the test/risk is on columns.}
}
\value{
Function \link{BooleanTable} returns a \linkS4class{BooleanTable} object.
}
\description{
To define and create a \linkS4class{BooleanTable}.
}
\details{
..
}
\section{Slots}{

\describe{
\item{\code{.Data}}{two-by-two \link[base]{integer} \link[base]{matrix},
contingency table of a Boolean test-&-disease table with layout
\tabular{lcc}{
\tab Test (\eqn{+}) \tab Test (\eqn{-}) \cr
Disease (\eqn{+}) \tab \eqn{x_{++}} \tab \eqn{x_{+-}} \cr
Disease (\eqn{-}) \tab \eqn{x_{-+}} \tab \eqn{x_{--}} \cr
}
or a Boolean risk-&-disease table with layout
\tabular{lcc}{
\tab Risk Factor (\eqn{+}) \tab Risk Factor (\eqn{-}) \cr
Disease (\eqn{+}) \tab \eqn{x_{++}} \tab \eqn{x_{+-}} \cr
Disease (\eqn{-}) \tab \eqn{x_{-+}} \tab \eqn{x_{--}} \cr
}
The endpoint (i.e., disease) must be on the rows and the test/risk be on the columns.
This set up is to accommodate \link[stats]{model.frame.default} and let end user use formula
\code{endpoint ~ test} or \code{endpoint ~ risk}.}
}}

\examples{
x = matrix(c(7L, 3L, 8L, 6L), nrow = 2L)
BooleanTable(x)
(x1 = matrix(c(7L, 3L, 8L, 6L), nrow = 2L, dimnames = list(X = c('a','b'), NULL)))
BooleanTable(x1)

}
\seealso{
End-user may also use \link[caret]{confusionMatrix},
which does not provide confidence intervals of
sensitivity, specificity, etc.
}
\keyword{internal}
