% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplitColType.r
\name{SplitColType}
\alias{SplitColType}
\title{Split data into discrete and continuous}
\usage{
SplitColType(data)
}
\arguments{
\item{data}{input data to be split, in either \link{data.frame} or \link{data.table} format.}
}
\value{
\code{discrete} all discrete features

\code{continous} all continuous features

\code{num_discrete} number of discrete features

\code{num_continuous} number of continuous features

\code{num_all_missing} number of features with no observations (all values are missing)
}
\description{
This function splits the input data into two \link{data.table} objects: discrete and continuous. A feature is continuous if \code{is.numeric} returns \code{TRUE}.
}
\details{
Features with all missing values will be dropped from the output data, but will be counted towards the column count.

The elements in the output list will have the same class as the input data.
}
\examples{
output <- SplitColType(iris)
output$discrete
output$continuous
output$num_discrete
output$num_continuous
output$num_all_missing
}
\keyword{splitcoltype}

