% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_boxplot.r
\name{plot_boxplot}
\alias{plot_boxplot}
\title{Create boxplot for continuous features}
\usage{
plot_boxplot(data, by, title = NULL, ...)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{by}{feature name to be broken down by. If selecting a continuous feature, boxplot will be grouped by 5 equal ranges, otherwise, all existing categories for a discrete feature.}

\item{title}{plot title}

\item{\dots}{other arguments to be passed to \link{geom_boxplot}.}
}
\description{
This function creates boxplot for each continuous feature based on a selected feature.
}
\examples{
# plot iris dataset by "Species" (discrete)
plot_boxplot(iris, by = "Species")

# plot mtcars dataset by "mpg" (continuous)
plot_boxplot(mtcars, "mpg")
}
\seealso{
\link{geom_boxplot}
}
\keyword{plot_boxplot}
