% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_boxplot.r
\name{plot_boxplot}
\alias{plot_boxplot}
\title{Create boxplot for continuous features}
\usage{
plot_boxplot(
  data,
  by,
  binary_as_factor = TRUE,
  geom_boxplot_args = list(),
  scale_y = "continuous",
  title = NULL,
  ggtheme = theme_gray(),
  theme_config = list(),
  nrow = 3L,
  ncol = 4L,
  parallel = FALSE
)
}
\arguments{
\item{data}{input data}

\item{by}{feature name to be broken down by. If selecting a continuous feature, boxplot will be grouped by 5 equal ranges, otherwise, all existing categories for a discrete feature.}

\item{binary_as_factor}{treat binary as categorical? Default is \code{TRUE}.}

\item{geom_boxplot_args}{a list of other arguments to \link{geom_boxplot}}

\item{scale_y}{scale of original y axis (before \code{coord_flip}). See \link{scale_y_continuous} for all options. Default is \code{continuous}.}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{nrow}{number of rows per page}

\item{ncol}{number of columns per page}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
This function creates boxplot for each continuous feature based on a selected feature.
}
\examples{
plot_boxplot(iris, by = "Species", ncol = 2L)
plot_boxplot(iris, by = "Species", geom_boxplot_args = list("outlier.color" = "red"))

# Plot skewed data on log scale
set.seed(1)
skew <- data.frame(y = rep(c("a", "b"), 500), replicate(4L, rbeta(1000, 1, 5000)))
plot_boxplot(skew, by = "y", ncol = 2L)
plot_boxplot(skew, by = "y", scale_y = "log10", ncol = 2L)
}
\seealso{
\link{geom_boxplot}
}
\keyword{plot_boxplot}
