% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbClearResult,DatabaseConnectorDbiResult-method}
\alias{dbClearResult,DatabaseConnectorDbiResult-method}
\title{Clear a result set}
\usage{
\S4method{dbClearResult}{DatabaseConnectorDbiResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbClearResult()} returns \code{TRUE}, invisibly, for result sets obtained from
both \code{dbSendQuery()}
and \code{dbSendStatement()}.
}
\description{
Frees all resources (local and remote) associated with a result set.
This step is mandatory for all objects obtained by calling
\code{\link[DBI:dbSendQuery]{dbSendQuery()}} or \code{\link[DBI:dbSendStatement]{dbSendStatement()}}.

}
\seealso{
Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()},
\code{\link[DBI]{dbUnquoteIdentifier}()}
}
