/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.starschema.clouddb.jdbc.BQConnection;
import net.starschema.clouddb.jdbc.Logger;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.CallContainer;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FunctionCall;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.SQLCleaner;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.Tree;

public class BQQueryParser {
    private String queryToParse = null;
    private BQConnection connection = null;
    Logger logger = Logger.getLogger(this.getClass());
    public boolean successFullParsing = false;
    private boolean formatted = true;
    public Node myNode = null;

    public BQQueryParser(String queryToParse, Connection connection) {
        this.setQueryToParse(queryToParse);
        this.connection = (BQConnection)connection;
    }

    public void asFormatted(boolean formatted) {
        this.formatted = formatted;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    /*
     * Could not resolve type clashes
     */
    public String parse() {
        if (!this.connection.getTransformQuery()) {
            return this.queryToParse;
        }
        this.successFullParsing = true;
        String catalog = "";
        try {
            catalog = this.connection.getCatalog();
            String catalogDecoded = catalog.replace("__", ":").replace("_", ".");
            this.queryToParse = this.queryToParse.replace(catalog, catalogDecoded);
        }
        catch (SQLException e2) {
            this.logger.warn("failed to replace the catalog in the query, catalog for the connection is: " + catalog);
        }
        this.logger.debug("The Query before parsing: " + this.queryToParse);
        try {
            TreeBuilder builder = new TreeBuilder(this.queryToParse, this.connection, new CallContainer());
            SelectStatement seleNode = null;
            try {
                seleNode = (SelectStatement)builder.buildSelect();
                SQLCleaner.Clean(seleNode);
            }
            catch (TreeParsingException e1) {
                this.logger.debug("Parsing failed", e1);
            }
            this.myNode = seleNode;
            String MainExpression = "SELECT " + Node.newline;
            Expression expression = seleNode.getExpression();
            LinkedList<Node> children = expression.getChildren();
            int i = 0;
            for (Node node : children) {
                List<String> synonyms2;
                ArrayList<Object> notAmbigous;
                List<String> synonyms;
                if (node.getTokenType() == 19) {
                    ColumnCall columnCall = (ColumnCall)ColumnCall.class.cast(node);
                    if (columnCall.getAlias() == null) {
                        Object string2;
                        synonyms = columnCall.getSynonyms();
                        notAmbigous = new ArrayList<Object>();
                        for (Object string2 : synonyms) {
                            boolean found = false;
                            int k = 0;
                            for (Node node2 : children) {
                                if (k != i) {
                                    if (node2.getTokenType() == 19) {
                                        ColumnCall columnCall2 = (ColumnCall)ColumnCall.class.cast(node2);
                                        synonyms2 = columnCall2.getSynonyms();
                                        for (String string22 : synonyms2) {
                                            if (!string22.equals(string2)) continue;
                                            found = true;
                                        }
                                    } else if (node2.getTokenType() == 53) {
                                        FunctionCall functionCall2 = (FunctionCall)FunctionCall.class.cast(node2);
                                        synonyms2 = functionCall2.getSynonyms();
                                        for (String string22 : synonyms2) {
                                            if (!string22.equals(string2)) continue;
                                            found = true;
                                        }
                                    }
                                }
                                ++k;
                            }
                            if (found) continue;
                            notAmbigous.add(string2);
                        }
                        ArrayList selected = new ArrayList();
                        string2 = notAmbigous.iterator();
                        while (string2.hasNext()) {
                            String string3 = (String)string2.next();
                            if (!string3.contains(columnCall.getName())) continue;
                            selected.add(string3);
                        }
                        String shortest = null;
                        int minOccurences = Integer.MAX_VALUE;
                        Iterator k = selected.iterator();
                        while (k.hasNext()) {
                            String string4 = (String)k.next();
                            int occurrences = 0;
                            for (int index = 0; index < string4.length() && (index = string4.indexOf(".", index)) >= 0; ++index) {
                                ++occurrences;
                            }
                            if (occurrences >= minOccurences) continue;
                            minOccurences = occurrences;
                            shortest = string4;
                        }
                        MainExpression = MainExpression + columnCall.getUniqueid() + " AS " + shortest;
                    } else {
                        MainExpression = MainExpression + columnCall.getUniqueid() + " AS " + columnCall.getAlias();
                    }
                } else if (node.getTokenType() == 53) {
                    FunctionCall functionCall = (FunctionCall)FunctionCall.class.cast(node);
                    if (functionCall.getAlias() == null) {
                        synonyms = functionCall.getSynonyms();
                        notAmbigous = new ArrayList();
                        for (String string : synonyms) {
                            boolean found = false;
                            int k = 0;
                            for (Node node2 : children) {
                                if (k != i) {
                                    if (node2.getTokenType() == 19) {
                                        ColumnCall columnCall2 = (ColumnCall)ColumnCall.class.cast(node2);
                                        synonyms2 = columnCall2.getSynonyms();
                                        for (String string22 : synonyms2) {
                                            if (!string22.equals(string)) continue;
                                            found = true;
                                        }
                                    } else if (node2.getTokenType() == 53) {
                                        FunctionCall functionCall2 = (FunctionCall)FunctionCall.class.cast(node2);
                                        synonyms2 = functionCall2.getSynonyms();
                                        for (String string22 : synonyms2) {
                                            if (!string22.equals(string)) continue;
                                            found = true;
                                        }
                                    }
                                }
                                ++k;
                            }
                            if (found) continue;
                            notAmbigous.add(string);
                        }
                        String shortest = null;
                        int minOccurences = Integer.MAX_VALUE;
                        for (String string : notAmbigous) {
                            int occurrences = 0;
                            for (int index = 0; index < string.length() && (index = string.indexOf(".", index)) >= 0; ++index) {
                                ++occurrences;
                            }
                            if (occurrences >= minOccurences) continue;
                            minOccurences = occurrences;
                            shortest = string;
                        }
                        MainExpression = MainExpression + functionCall.getUniqueid() + " AS " + shortest;
                    } else {
                        MainExpression = MainExpression + functionCall.getUniqueid() + " AS " + functionCall.getAlias();
                    }
                }
                if (++i >= children.size()) continue;
                MainExpression = MainExpression + ", " + Node.newline;
            }
            MainExpression = MainExpression + Node.newline + " FROM (";
            this.queryToParse = this.formatted ? seleNode.toPrettyString(1) : seleNode.toPrettyString();
            this.queryToParse = MainExpression + this.queryToParse + ")";
        }
        catch (RecognitionException e1) {
            this.logger.info("Parsing failed", e1);
            this.successFullParsing = false;
        }
        catch (Exception e) {
            this.logger.info("Parsing failed", e);
            this.successFullParsing = false;
        }
        return this.queryToParse;
    }

    private boolean treeContainsErrors(Tree tree) {
        if (tree instanceof CommonErrorNode) {
            return true;
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            if (!this.treeContainsErrors(tree.getChild(i))) continue;
            return true;
        }
        return false;
    }

    public Tree parseDataDefinition() {
        this.successFullParsing = true;
        Tree tree = null;
        try {
            TreeBuilder builder = new TreeBuilder(this.queryToParse, this.connection, new CallContainer());
            try {
                tree = builder.buildTree();
            }
            catch (TreeParsingException e1) {
                this.logger.debug("Parsing failed", e1);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.info("Parsing failed", e);
        }
        if (this.treeContainsErrors(tree)) {
            return null;
        }
        if (tree.getText().equals("CREATETABLESTATEMENT") || tree.getText().equals("DROPTABLESTATEMENT") || tree.getText().equals("TRUNCATETABLESTATEMENT") || tree.getText().equals("INSERTFROMSELECTSTATEMENT") || tree.getText().equals("SELECTINTOSTATEMENT")) {
            return tree;
        }
        return null;
    }

    public void setConnection(Connection connection) {
        this.connection = (BQConnection)connection;
    }

    public void setQueryToParse(String queryToParse) {
        this.queryToParse = queryToParse;
    }
}

