/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.ColumnReferencePlace;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FromExpression;
import net.starschema.clouddb.jdbc.list.FunctionCall;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.SynonymContainer;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import net.starschema.clouddb.jdbc.list.UniQueIdContainer;
import org.antlr.runtime.tree.Tree;

public class ColumnReference
extends Node
implements UniQueIdContainer {
    String name = null;
    String[] prefixes = null;
    String[] aliases = null;
    String uniqueId = null;
    private UniQueIdContainer pointedNode;
    private List<UniQueIdContainer> extraPointedNodes = null;
    SelectStatement selectStatement;
    TreeBuilder builder;

    public void addExtraPointedNode(UniQueIdContainer uniQueIdContainer) {
        if (this.extraPointedNodes == null) {
            this.extraPointedNodes = new ArrayList<UniQueIdContainer>();
        }
        this.extraPointedNodes.add(uniQueIdContainer);
        if (((Node)Node.class.cast((Object)uniQueIdContainer)).tokenType == 19) {
            ColumnCall columnCall = (ColumnCall)ColumnCall.class.cast(uniQueIdContainer);
            columnCall.addNodePointingToThis(this);
        }
    }

    public void setPointedNode(UniQueIdContainer pointedNode) {
        ColumnCall columnCall;
        if (this.pointedNode != null && this.pointedNode.getTokenType() == 19) {
            columnCall = (ColumnCall)ColumnCall.class.cast(this.pointedNode);
            columnCall.removeNodePointingToThis(this);
        }
        this.pointedNode = pointedNode;
        if (this.pointedNode != null && this.pointedNode.getTokenType() == 19) {
            columnCall = (ColumnCall)ColumnCall.class.cast(this.pointedNode);
            columnCall.addNodePointingToThis(this);
        }
    }

    public ColumnReference(String[] prefixes, TreeBuilder builder, String name) {
        this.name = name;
        this.prefixes = prefixes;
        this.builder = builder;
        this.uniqueId = builder.getuniqueid();
        this.tokenType = 19;
        this.tokenName = JdbcGrammarParser.tokenNames[19];
    }

    public ColumnReference(String[] prefixes, TreeBuilder builder, String name, UniQueIdContainer pointedNode) {
        this.name = name;
        this.prefixes = prefixes;
        this.builder = builder;
        this.setPointedNode(pointedNode);
        this.uniqueId = builder.getuniqueid();
        this.tokenType = 19;
        this.tokenName = JdbcGrammarParser.tokenNames[19];
    }

    public ColumnReference(Tree t, TreeBuilder treeBuilder, SelectStatement selectStatement) throws TreeParsingException {
        this.selectStatement = selectStatement;
        this.builder = treeBuilder;
        this.uniqueId = this.builder.getuniqueid();
        this.build(t, this.builder);
    }

    public ColumnReference(Tree t, TreeBuilder treeBuilder, SelectStatement selectStatement, ColumnReferencePlace node) throws TreeParsingException {
        this.selectStatement = selectStatement;
        ArrayList<String> scopeList = new ArrayList<String>();
        block24: for (int i = 0; i < t.getChildCount(); ++i) {
            Tree child = t.getChild(i);
            switch (child.getType()) {
                case 94: {
                    this.name = child.getChild(0).getText();
                    continue block24;
                }
                case 118: {
                    scopeList.add(child.getChild(0).getText());
                    continue block24;
                }
            }
        }
        this.prefixes = scopeList.toArray(new String[scopeList.size()]);
        switch (node.getMainNode().getTokenType()) {
            case 137: {
                try {
                    List<UniQueIdContainer> pointedNodeInFromExpression = this.searchPointedNodeInFromExpression(selectStatement.getFromExpression());
                    this.setPointedNode(pointedNodeInFromExpression.get(0));
                    for (UniQueIdContainer uniQueIdContainer : pointedNodeInFromExpression) {
                        this.addExtraPointedNode(uniQueIdContainer);
                    }
                    break;
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse out the WhereExpression", e);
                    break;
                }
            }
            case 59: {
                try {
                    UniQueIdContainer pointedNodeInFromExpression = this.searchPointedNodeInExpression(selectStatement.getExpression());
                    this.setPointedNode(pointedNodeInFromExpression);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse out HavingExpression", e);
                }
                break;
            }
            case 54: {
                try {
                    List<UniQueIdContainer> pointedNodeInFromExpression = this.searchPointedNodeInFromExpression(selectStatement.getFromExpression());
                    this.setPointedNode(pointedNodeInFromExpression.get(0));
                    for (UniQueIdContainer uniQueIdContainer : pointedNodeInFromExpression) {
                        this.addExtraPointedNode(uniQueIdContainer);
                    }
                    break;
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse out FunctionParameters", e);
                    break;
                }
            }
            case 24: {
                try {
                    List<UniQueIdContainer> pointedNodeInFromExpression = this.searchPointedNodeInFromExpression(selectStatement.getFromExpression());
                    this.setPointedNode(pointedNodeInFromExpression.get(0));
                    for (UniQueIdContainer uniQueIdContainer : pointedNodeInFromExpression) {
                        this.addExtraPointedNode(uniQueIdContainer);
                    }
                    break;
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse out Onclause", e);
                    break;
                }
            }
            case 104: {
                try {
                    UniQueIdContainer searchPointedNodeInExpression = this.searchPointedNodeInExpression(this.selectStatement.getExpression());
                    this.setPointedNode(searchPointedNodeInExpression);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse out Order by Clause", e);
                }
                break;
            }
            case 56: {
                try {
                    UniQueIdContainer searchPointedNodeInExpression = this.searchPointedNodeInExpression(this.selectStatement.getExpression());
                    this.setPointedNode(searchPointedNodeInExpression);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse out Group By Expression", e);
                }
                break;
            }
        }
        this.builder = treeBuilder;
        this.uniqueId = this.builder.getuniqueid();
        this.build(t, this.builder);
    }

    public void addPrefixToEnd(String prefix) {
        if (this.prefixes == null) {
            this.prefixes = new String[]{prefix};
        } else {
            String[] temp = this.prefixes;
            this.prefixes = new String[this.prefixes.length + 1];
            int i = 0;
            String[] stringArray = temp;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String string;
                this.prefixes[i] = string = stringArray[j];
                ++i;
            }
            this.prefixes[this.prefixes.length - 1] = prefix;
        }
    }

    public void addPrefixtoFront(String prefix) {
        if (this.prefixes == null) {
            this.prefixes = new String[]{prefix};
        } else {
            String[] temp = this.prefixes;
            this.prefixes = new String[this.prefixes.length + 1];
            this.prefixes[0] = prefix;
            int i = 1;
            String[] stringArray = temp;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String string;
                this.prefixes[i] = string = stringArray[j];
                ++i;
            }
        }
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException {
        if (t.getType() == 19) {
            this.tokenName = JdbcGrammarParser.tokenNames[t.getType()];
            this.tokenType = t.getType();
            this.logger.debug("BUILDING " + this.tokenName);
            ArrayList<String> scopeList = new ArrayList<String>();
            ArrayList<String> aliasList = new ArrayList<String>();
            block5: for (int i = 0; i < t.getChildCount(); ++i) {
                Tree child = t.getChild(i);
                switch (child.getType()) {
                    case 94: {
                        this.name = child.getChild(0).getText();
                        continue block5;
                    }
                    case 118: {
                        scopeList.add(child.getChild(0).getText());
                        continue block5;
                    }
                    case 5: {
                        aliasList.add(child.getChild(0).getText());
                        continue block5;
                    }
                }
            }
            if (aliasList.size() != 0) {
                this.aliases = aliasList.toArray(new String[aliasList.size()]);
            }
            if (scopeList.size() != 0) {
                this.prefixes = scopeList.toArray(new String[scopeList.size()]);
            }
        } else {
            throw new TreeParsingException(19, t.getType());
        }
    }

    public String getAlias() {
        String forreturn = "";
        if (this.aliases == null) {
            return null;
        }
        for (String iter : this.aliases) {
            forreturn = forreturn + iter + "_";
        }
        return forreturn.substring(0, forreturn.length() - 1);
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getName() {
        return this.name;
    }

    public UniQueIdContainer getPointedNode() {
        return this.pointedNode;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public String[] getScopes() {
        return this.prefixes;
    }

    public String getwholename() {
        String name = "";
        if (this.getScopes() != null) {
            for (String scope : this.getScopes()) {
                name = name + scope + ".";
            }
        }
        name = name + this.getName();
        return name;
    }

    private List<UniQueIdContainer> searchPointedNodeInFromExpression(FromExpression fromExpression) throws ColumnCallException {
        this.logger.debug("IN SEARCH");
        List<SubQuery> subQueries = fromExpression.getSubQueries();
        if (subQueries != null) {
            ArrayList<UniQueIdContainer> validPointedNodes = new ArrayList<UniQueIdContainer>();
            for (SubQuery subQuery : subQueries) {
                List<SynonymContainer> availableResources = subQuery.getAvailableResources();
                for (SynonymContainer synonymContainer : availableResources) {
                    List<String> synonyms = synonymContainer.getSynonyms();
                    for (String string : synonyms) {
                        if (string == null || !string.equals(this.getwholename())) continue;
                        this.logger.debug("ADDING NODE");
                        validPointedNodes.add(synonymContainer.getPointedResource());
                    }
                }
            }
            if (validPointedNodes.size() > 1) {
                boolean sameUniqueId = true;
                String uniqueId = ((UniQueIdContainer)validPointedNodes.get(0)).getUniqueid();
                for (UniQueIdContainer uniQueIdContainer : validPointedNodes) {
                    if (uniQueIdContainer.getUniqueid().equals(uniqueId)) continue;
                    sameUniqueId = false;
                }
                if (!sameUniqueId) {
                    throw new ColumnCallException("AMBIGOUS COLUMNCALL: " + this.getName());
                }
                return validPointedNodes;
            }
            if (validPointedNodes.size() == 1) {
                return validPointedNodes;
            }
            return null;
        }
        return null;
    }

    private UniQueIdContainer searchPointedNodeInExpression(Expression expression) throws ColumnCallException {
        List<ColumnCall> columns = expression.getColumns();
        List<FunctionCall> functionCalls = expression.getFunctionCalls();
        ArrayList<Node> possibleNodes = new ArrayList<Node>();
        if (columns != null) {
            for (ColumnCall columnCall : columns) {
                List<String> synonyms = columnCall.getSynonyms();
                for (String string : synonyms) {
                    if (!string.equals(this.getwholename())) continue;
                    possibleNodes.add(columnCall);
                }
            }
        }
        if (functionCalls != null) {
            for (FunctionCall functionCall : functionCalls) {
                if (functionCall.getAlias() == null || !functionCall.getAlias().equals(this.getwholename())) continue;
                possibleNodes.add(functionCall);
            }
        }
        if (possibleNodes.size() > 1) {
            throw new ColumnCallException("AMBIGOUS COLUMNCALL: " + this.getName());
        }
        if (possibleNodes.size() == 1) {
            return (UniQueIdContainer)possibleNodes.get(0);
        }
        return null;
    }

    public UniQueIdContainer searchPointedNodeInSubQuery(SubQuery subQuery) throws ColumnCallException {
        ArrayList<UniQueIdContainer> validPointedNodes = new ArrayList<UniQueIdContainer>();
        List<SynonymContainer> availableResources = subQuery.getAvailableResources();
        for (SynonymContainer synonymContainer : availableResources) {
            List<String> synonyms = synonymContainer.getSynonyms();
            for (String string : synonyms) {
                String wholeName = this.getwholename();
                if (string == null || !string.equals(wholeName)) continue;
                this.logger.debug("ADDING NODE");
                validPointedNodes.add(synonymContainer.getPointedResource());
                this.logger.debug("FOUND");
            }
        }
        if (validPointedNodes.size() > 1) {
            throw new ColumnCallException("AMBIGOUS COLUMNCALL: " + this.getName());
        }
        if (validPointedNodes.size() == 1) {
            return (UniQueIdContainer)validPointedNodes.get(0);
        }
        return null;
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        if (this.getPointedNode() != null) {
            if (this.getPointedNode().getTokenType() == 19) {
                String retString = "";
                if (((ColumnCall)ColumnCall.class.cast((Object)this.getPointedNode())).parentNode != null && ((ColumnCall)ColumnCall.class.cast((Object)this.getPointedNode())).parentNode.selectStatement != null && ((ColumnCall)ColumnCall.class.cast((Object)this.getPointedNode())).parentNode.selectStatement.parent != null && ((ColumnCall)ColumnCall.class.cast((Object)this.getPointedNode())).parentNode.selectStatement.parent.isPartOfJoin() && ((ColumnCall)ColumnCall.class.cast((Object)this.getPointedNode())).parentNode.selectStatement.parent.alias != null) {
                    retString = ((ColumnCall)ColumnCall.class.cast((Object)this.getPointedNode())).parentNode.selectStatement.parent.alias + ".";
                }
                return retString + ((ColumnCall)ColumnCall.class.cast((Object)this.getPointedNode())).uniqueId;
            }
            String retString = "";
            FunctionCall cast = (FunctionCall)FunctionCall.class.cast(this.getPointedNode());
            if (cast.parentNode != null && cast.parentNode.selectStatement != null && cast.parentNode.selectStatement.parent != null && cast.parentNode.selectStatement.parent.isPartOfJoin() && cast.parentNode.selectStatement.parent.alias != null) {
                retString = cast.parentNode.selectStatement.parent.alias + ".";
            }
            return retString + cast.uniqueId;
        }
        return this.getName();
    }

    @Override
    public String getUniqueid() {
        return this.uniqueId;
    }
}

