/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FromExpression;
import net.starschema.clouddb.jdbc.list.FunctionParameter;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.StringLiteral;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import net.starschema.clouddb.jdbc.list.UniQueIdContainer;
import org.antlr.runtime.tree.Tree;

public class FunctionCall
extends Node
implements UniQueIdContainer {
    String name = null;
    String alias = null;
    String uniqueId = null;
    Expression parentNode = null;
    SelectStatement selectStatement;
    TreeBuilder builder;
    FromExpression fromExpression;

    public Expression getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Expression parentNode) {
        this.parentNode = parentNode;
    }

    public List<String> getSynonyms() {
        ArrayList<String> returnList = new ArrayList<String>();
        SubQuery parent = this.parentNode.selectStatement.parent;
        if (this.getAlias() != null) {
            returnList.add(this.getAlias());
            if (parent != null && parent.getAlias() != null) {
                returnList.add(parent.getAlias() + "." + this.getAlias());
            }
            return returnList;
        }
        returnList.add(this.uniqueId);
        returnList.add(parent.getAlias() + "." + this.uniqueId);
        return returnList;
    }

    public FunctionCall(Tree t, TreeBuilder treeBuilder, SelectStatement selectStatement) throws TreeParsingException {
        this.builder = treeBuilder;
        this.selectStatement = selectStatement;
        this.fromExpression = selectStatement.getFromExpression();
        this.uniqueId = this.builder.getuniqueid();
        this.build(t, this.builder);
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException {
        if (t.getType() == 53) {
            this.tokenName = JdbcGrammarParser.tokenNames[t.getType()];
            this.tokenType = t.getType();
            this.logger.debug("BUILDING " + this.tokenName);
            block5: for (int i = 0; i < t.getChildCount(); ++i) {
                Tree child = t.getChild(i);
                switch (child.getType()) {
                    case 54: {
                        this.children.addLast(new FunctionParameter(child, builder, this.selectStatement));
                        continue block5;
                    }
                    case 5: {
                        this.alias = child.getChild(0).getText();
                        continue block5;
                    }
                    case 94: {
                        this.name = child.getChild(0).getText();
                        continue block5;
                    }
                }
            }
            if (this.getName().toLowerCase().equals("COUNT".toLowerCase()) && this.children.size() == 1) {
                for (Node Child : this.children) {
                    SubQuery subQuery;
                    Expression expression;
                    List<ColumnCall> columns;
                    FromExpression fromExpression2;
                    List<SubQuery> subQueries;
                    FunctionParameter functionParameter = (FunctionParameter)FunctionParameter.class.cast(Child);
                    if (functionParameter.getRefobject().tokenType != 125) continue;
                    StringLiteral stringLiteral = (StringLiteral)StringLiteral.class.cast(functionParameter.getRefobject());
                    if (!stringLiteral.data.equals("*") || (subQueries = (fromExpression2 = this.selectStatement.getFromExpression()).getSubQueries()) == null || (columns = (expression = (subQuery = subQueries.get(0)).getSelectStatement().getExpression()).getColumns()) == null) continue;
                    for (ColumnCall columnCall : columns) {
                        columnCall.addNodePointingToThis(this);
                    }
                }
            }
            if (this.getAlias() == null) {
                this.alias = this.uniqueId;
            }
        } else {
            throw new TreeParsingException("This Tree is not a FUNCTIONCALL");
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public List<FunctionParameter> getFunctionParameters() {
        return this.getAllinstancesof(FunctionParameter.class, 54);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        String result = this.name + "(";
        for (Node node : this.children) {
            result = result + node.toPrettyString() + ",";
        }
        result = result.substring(0, result.length() - 1);
        result = result + ")";
        return result + " AS " + this.uniqueId;
    }

    @Override
    public String getUniqueid() {
        return this.uniqueId;
    }
}

