/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.starschema.clouddb.jdbc.Logger;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.BooleanExpressionItem;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.ColumnReference;
import net.starschema.clouddb.jdbc.list.Conjunction;
import net.starschema.clouddb.jdbc.list.Disjunction;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FromExpression;
import net.starschema.clouddb.jdbc.list.FunctionCall;
import net.starschema.clouddb.jdbc.list.JoinChain;
import net.starschema.clouddb.jdbc.list.JoinElement;
import net.starschema.clouddb.jdbc.list.JoinExpression;
import net.starschema.clouddb.jdbc.list.LogicalOperator;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.OnClause;
import net.starschema.clouddb.jdbc.list.OnClauseCondition;
import net.starschema.clouddb.jdbc.list.Resolver;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.SourceTable;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import net.starschema.clouddb.jdbc.list.UniQueIdContainer;
import net.starschema.clouddb.jdbc.list.WhereExpression;

public class WhereExpressionJoinResolver {
    static Logger logger = Logger.getLogger("net.starschema.clouddb.jdjbc.list.WhereExpressionJoinResolver");

    public static SubQuery mkSubQFromJoinExpr(JoinExpression joinExpression, TreeBuilder builder, SelectStatement selectStatement) {
        String id = builder.getuniqueid();
        Resolver resolver = new Resolver(builder);
        List<ColumnCall> callsLeft = joinExpression.leftItem.tokenType == 126 ? resolver.parseSubQForJokers((SubQuery)joinExpression.leftItem) : resolver.parseSrcTableForJokers((SourceTable)joinExpression.leftItem);
        List<ColumnCall> callsRight = joinExpression.rightItem.tokenType == 126 ? resolver.parseSubQForJokers((SubQuery)joinExpression.rightItem) : resolver.parseSrcTableForJokers((SourceTable)joinExpression.rightItem);
        ArrayList<ColumnCall> allColumns = new ArrayList<ColumnCall>();
        allColumns.addAll(callsLeft);
        allColumns.addAll(callsRight);
        FromExpression fromExpressionForBuild = new FromExpression(builder, joinExpression);
        Expression expressionForBuild = null;
        expressionForBuild = new Expression(allColumns, builder);
        for (ColumnCall columnCall : allColumns) {
            columnCall.setParentNode(expressionForBuild);
        }
        SelectStatement selectStatementForBuild = new SelectStatement(builder, expressionForBuild, fromExpressionForBuild);
        expressionForBuild.setSelectStatement(selectStatementForBuild);
        return new SubQuery(id, builder, selectStatementForBuild, id);
    }

    public static JoinExpression mkJoinExprFrmTwoSubQ(SubQuery left, SubQuery right) {
        ColumnCall leftAddition = new ColumnCall(null, (List<String>)new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("EQUIVALENT_COLUMN");
            }
        }, left.builder, "true", left.getSelectStatement().getExpression());
        ColumnCall rightAddition = new ColumnCall(null, (List<String>)new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("EQUIVALENT_COLUMN");
            }
        }, left.builder, "true", right.getSelectStatement().getExpression());
        leftAddition.setEquivalentCol(true);
        rightAddition.setEquivalentCol(true);
        left.getSelectStatement().getExpression().children.addLast(leftAddition);
        right.getSelectStatement().getExpression().children.addLast(rightAddition);
        String leftAlias = left.getAlias();
        String rightAlias = right.getAlias();
        ArrayList<OnClauseCondition> conditions = new ArrayList<OnClauseCondition>();
        OnClauseCondition condition = new OnClauseCondition(left.builder, "=", new ColumnReference(new String[]{leftAlias}, left.builder, "EQUIVALENT_COLUMN", leftAddition), new ColumnReference(new String[]{rightAlias}, left.builder, "EQUIVALENT_COLUMN", rightAddition));
        conditions.add(condition);
        OnClause onClause = new OnClause(left.builder, conditions, null);
        JoinExpression joinExpression = new JoinExpression(left.builder, left, right, onClause, left.selectStatement);
        return joinExpression;
    }

    /*
     * WARNING - void declaration
     */
    public static List<SubQuery> mkJoinExprFrmDisjunction(Disjunction disjunction, SelectStatement selectStatement) {
        void var9_12;
        LinkedList<Node> childList = disjunction.getChildren();
        ArrayList<SubQuery> subqueries = new ArrayList<SubQuery>();
        for (Node node : childList) {
            if (node.getTokenType() == 27) {
                subqueries.add(WhereExpressionJoinResolver.mkJoinExprFrmConjunction((Conjunction)node, selectStatement));
                continue;
            }
            if (node.getTokenType() != 13) continue;
            logger.debug("THE BOOLEANEXPRESSIONITEM: " + ((BooleanExpressionItem)BooleanExpressionItem.class.cast(node)).toPrettyString());
            subqueries.add(WhereExpressionJoinResolver.mkJoinExprFrmBooleanExprItem((BooleanExpressionItem)node, selectStatement));
        }
        SubQuery mainSubQuery = (SubQuery)subqueries.get(0);
        Expression mainExpression = mainSubQuery.getSelectStatement().getExpression();
        List<ColumnCall> columns2 = mainExpression.getColumns();
        ArrayList<ColumnCall> columns = new ArrayList<ColumnCall>();
        for (ColumnCall columnCall : columns2) {
            if (!columnCall.getEquivalentCol()) {
                columns.add(columnCall);
                continue;
            }
            mainExpression.children.remove(columnCall);
        }
        ArrayList<Node> pointedNodeList = new ArrayList<Node>();
        for (ColumnCall columnCall : columns) {
            Node pointedNode = columnCall.getPointedNode();
            Object nextPointedNode = null;
            if (pointedNode.getTokenType() == 19) {
                nextPointedNode = ((ColumnCall)pointedNode).getPointedNode();
            } else if (pointedNode.getTokenType() == 53) {
                nextPointedNode = null;
            }
            while (nextPointedNode != null) {
                logger.debug("Getting last pointed node:");
                if (((Node)nextPointedNode).getTokenType() == 19) {
                    nextPointedNode = ((ColumnCall)nextPointedNode).getPointedNode();
                    continue;
                }
                if (((Node)nextPointedNode).getTokenType() != 53) continue;
                nextPointedNode = null;
            }
            pointedNodeList.add(pointedNode);
        }
        boolean bl = true;
        while (var9_12 < subqueries.size()) {
            ArrayList<ColumnCall> arrayList = new ArrayList<ColumnCall>();
            List<ColumnCall> subcolumns2 = ((SubQuery)subqueries.get((int)var9_12)).getSelectStatement().getExpression().getColumns();
            for (ColumnCall columnCall : subcolumns2) {
                if (!columnCall.getEquivalentCol()) {
                    arrayList.add(columnCall);
                    continue;
                }
                ((SubQuery)subqueries.get((int)var9_12)).getSelectStatement().getExpression().children.remove(columnCall);
            }
            ArrayList<Node> subPointedNodeList = new ArrayList<Node>();
            for (ColumnCall columnCall : arrayList) {
                Node pointedNode = columnCall.getPointedNode();
                Node nextPointedNode = null;
                if (pointedNode.getTokenType() == 19) {
                    nextPointedNode = ((ColumnCall)pointedNode).getPointedNode();
                } else if (pointedNode.getTokenType() == 53) {
                    nextPointedNode = null;
                }
                while (nextPointedNode != null) {
                    if (nextPointedNode.getTokenType() == 19) {
                        nextPointedNode = ((ColumnCall)nextPointedNode).getPointedNode();
                        continue;
                    }
                    if (nextPointedNode.getTokenType() != 53) continue;
                    nextPointedNode = null;
                }
                subPointedNodeList.add(pointedNode);
                int main = 0;
                for (Node mainPointedNode : pointedNodeList) {
                    int sub = 0;
                    for (Node subPointedNode : subPointedNodeList) {
                        if (subPointedNode.getTokenType() != 19) continue;
                        ColumnCall subpointedColumnCall = (ColumnCall)ColumnCall.class.cast(subPointedNode);
                        if (mainPointedNode.getTokenType() == 19) {
                            ColumnCall mainpointedColumnCall = (ColumnCall)ColumnCall.class.cast(mainPointedNode);
                            if (mainpointedColumnCall.uniqueId.equals(subpointedColumnCall.uniqueId)) {
                                ((ColumnCall)arrayList.get((int)sub)).uniqueId = ((ColumnCall)columns.get((int)main)).uniqueId;
                                break;
                            }
                        } else if (subPointedNode.getTokenType() == 53) {
                            FunctionCall subpointedFunctionCall = (FunctionCall)FunctionCall.class.cast(subPointedNode);
                            if (mainPointedNode.getTokenType() == 53) {
                                FunctionCall mainpointedFunctionCall = (FunctionCall)FunctionCall.class.cast(mainPointedNode);
                                if (mainpointedFunctionCall.uniqueId.equals(subpointedFunctionCall.uniqueId)) {
                                    ((ColumnCall)arrayList.get((int)sub)).uniqueId = ((ColumnCall)columns.get((int)main)).uniqueId;
                                    break;
                                }
                            }
                        }
                        ++sub;
                    }
                    ++main;
                }
            }
            ++var9_12;
        }
        return subqueries;
    }

    public static SubQuery mkJoinExprFrmBooleanExprItem(BooleanExpressionItem item, SelectStatement selectStatement) {
        if (WhereExpressionJoinResolver.isValidJoinTerm(item)) {
            ArrayList<Node> referencedNodes = new ArrayList<Node>();
            block5: for (Node node : selectStatement.getFromExpression().children) {
                logger.debug("FromExpressions Children " + node.toPrettyString().replace("\n", "").replace("\r", ""));
                switch (node.getTokenType()) {
                    case 126: {
                        for (Node call : ((SubQuery)SubQuery.class.cast((Object)node)).getSelectStatement().getExpression().children) {
                            UniQueIdContainer callCast = (UniQueIdContainer)UniQueIdContainer.class.cast(call);
                            UniQueIdContainer pointedNodeLeft = ((ColumnReference)ColumnReference.class.cast(item.left)).getPointedNode();
                            UniQueIdContainer pointedNodeRight = ((ColumnReference)ColumnReference.class.cast(item.right)).getPointedNode();
                            String uniqueIdLeft = pointedNodeLeft.getUniqueid();
                            String uniqueIdRight = pointedNodeRight.getUniqueid();
                            if (!callCast.getUniqueid().equals(uniqueIdLeft) && !callCast.getUniqueid().equals(uniqueIdRight)) continue;
                            referencedNodes.add(node);
                        }
                        continue block5;
                    }
                }
            }
            logger.debug("Referenced Nodes size is: " + referencedNodes.size());
            JoinElement element = new JoinElement(item, referencedNodes);
            JoinChain chain = new JoinChain();
            chain.addElement(element);
            SubQuery right = chain.getJoinExpression();
            LinkedList children = selectStatement.getFromExpression().children;
            for (Node node : children) {
                boolean found = false;
                for (Node node2 : chain.getIncludednodes()) {
                    if (!node.equals(node2)) continue;
                    found = true;
                }
                if (found) continue;
                JoinExpression expr = WhereExpressionJoinResolver.mkJoinExprFrmTwoSubQ(right, (SubQuery)node);
                right = WhereExpressionJoinResolver.mkSubQFromJoinExpr(expr, expr.builder, expr.selectStatement);
            }
            return right;
        }
        FromExpression fromExpression = selectStatement.getFromExpression();
        List<SubQuery> subQueries = fromExpression.getSubQueries();
        if (subQueries == null || subQueries.size() == 1) {
            return null;
        }
        SubQuery left = null;
        for (SubQuery subQuery : subQueries) {
            if (left == null) {
                left = subQuery;
                continue;
            }
            JoinExpression createJoinExpressionFromTwoSubQueries = WhereExpressionJoinResolver.mkJoinExprFrmTwoSubQ(left, subQuery);
            left = WhereExpressionJoinResolver.mkSubQFromJoinExpr(createJoinExpressionFromTwoSubQueries, selectStatement.builder, selectStatement);
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(item);
            try {
                left.selectStatement.whereExpression = new WhereExpression(nodes, left.selectStatement.builder, left.selectStatement);
            }
            catch (TreeParsingException e) {
                e.printStackTrace();
            }
        }
        return left;
    }

    /*
     * WARNING - void declaration
     */
    public static SubQuery mkJoinExprFrmConjunction(Conjunction conjunction, SelectStatement selectStatement) {
        void var14_27;
        ArrayList<Node> validNodes = new ArrayList<Node>();
        ArrayList<Node> notValidNodes = new ArrayList<Node>();
        for (Node item : conjunction.children) {
            if (WhereExpressionJoinResolver.isValidJoinTerm((BooleanExpressionItem)item)) {
                validNodes.add(item);
                continue;
            }
            notValidNodes.add(item);
        }
        if (validNodes.isEmpty()) {
            return null;
        }
        ArrayList<BooleanExpressionItem> keys = new ArrayList<BooleanExpressionItem>();
        ArrayList<Object> referencedNodes = new ArrayList<Object>();
        FromExpression fromExpression = selectStatement.getFromExpression();
        for (Node validnode : validNodes) {
            keys.add((BooleanExpressionItem)validnode);
            ArrayList nodelist = new ArrayList();
            block7: for (Node node : fromExpression.children) {
                switch (node.getTokenType()) {
                    case 126: {
                        for (Object call : ((SubQuery)SubQuery.class.cast((Object)node)).getSelectStatement().getExpression().children) {
                            void var14_15;
                            Node cast;
                            Object var14_16 = null;
                            String uniqueIdRight = null;
                            UniQueIdContainer pointedNodeLeft = ((ColumnReference)((BooleanExpressionItem)validnode).left).getPointedNode();
                            if (pointedNodeLeft.getTokenType() == 19) {
                                String string = ((ColumnCall)pointedNodeLeft).uniqueId;
                            } else if (pointedNodeLeft.getTokenType() == 53) {
                                String string = ((FunctionCall)pointedNodeLeft).uniqueId;
                            }
                            UniQueIdContainer pointedNodeRight = ((ColumnReference)((BooleanExpressionItem)validnode).right).getPointedNode();
                            if (pointedNodeRight.getTokenType() == 19) {
                                uniqueIdRight = ((ColumnCall)pointedNodeRight).uniqueId;
                            } else if (pointedNodeRight.getTokenType() == 53) {
                                uniqueIdRight = ((FunctionCall)pointedNodeRight).uniqueId;
                            }
                            if (((Node)call).tokenType == 19) {
                                cast = (ColumnCall)ColumnCall.class.cast(call);
                                if (cast.uniqueId.equals(var14_15) || cast.uniqueId.equals(uniqueIdRight)) {
                                    nodelist.add(node);
                                }
                            }
                            if (((Node)call).tokenType != 53) continue;
                            cast = (FunctionCall)FunctionCall.class.cast(call);
                            if (!((FunctionCall)cast).uniqueId.equals(var14_15) && !((FunctionCall)cast).uniqueId.equals(uniqueIdRight)) continue;
                            nodelist.add(node);
                        }
                        continue block7;
                    }
                }
            }
            referencedNodes.add(nodelist);
        }
        ArrayList<JoinElement> joinElements = new ArrayList<JoinElement>();
        int l = 0;
        for (Node node : validNodes) {
            List nodeList = (List)referencedNodes.get(l);
            JoinElement element = new JoinElement((BooleanExpressionItem)BooleanExpressionItem.class.cast(node), nodeList);
            joinElements.add(element);
            ++l;
        }
        ArrayList<JoinChain> joinChains = new ArrayList<JoinChain>();
        JoinChain chain = new JoinChain();
        for (JoinElement joinElement : joinElements) {
            chain.addElement(joinElement);
        }
        joinChains.add(chain);
        List<JoinElement> joinElementsLeft = chain.getNotconnected();
        while (joinElementsLeft.size() != 0) {
            JoinChain chaintemp = new JoinChain();
            for (JoinElement joinElement : joinElementsLeft) {
                chaintemp.addElement(joinElement);
            }
            joinElementsLeft = chaintemp.getNotconnected();
            joinChains.add(chaintemp);
        }
        ArrayList<Node> includedNodes = new ArrayList<Node>();
        ArrayList<SubQuery> subQueries = new ArrayList<SubQuery>();
        for (JoinChain joinChain : joinChains) {
            subQueries.add(joinChain.getJoinExpression());
            includedNodes.addAll(joinChain.getIncludednodes());
        }
        Object var14_22 = null;
        for (int i = subQueries.size() - 1; i > -1; --i) {
            void var14_23;
            if (var14_23 == null) {
                SubQuery subQuery = (SubQuery)subQueries.get(i);
                continue;
            }
            JoinExpression expr = WhereExpressionJoinResolver.mkJoinExprFrmTwoSubQ((SubQuery)var14_23, (SubQuery)subQueries.get(i));
            SubQuery subQuery = WhereExpressionJoinResolver.mkSubQFromJoinExpr(expr, expr.builder, expr.selectStatement);
        }
        LinkedList children = fromExpression.children;
        for (Node node : children) {
            boolean found = false;
            for (Node node2 : includedNodes) {
                if (!node.equals(node2)) continue;
                found = true;
            }
            if (found) continue;
            JoinExpression expr = WhereExpressionJoinResolver.mkJoinExprFrmTwoSubQ((SubQuery)var14_27, (SubQuery)node);
            SubQuery subQuery = WhereExpressionJoinResolver.mkSubQFromJoinExpr(expr, expr.builder, expr.selectStatement);
        }
        logger.debug("ADDING NOT VALID NODES AT THE END");
        if (notValidNodes.size() != 0) {
            try {
                var14_27.selectStatement.whereExpression = new WhereExpression(notValidNodes, var14_27.selectStatement.builder, var14_27.selectStatement);
                logger.debug("ADDING NOT VALID NODES AT THE END PHASE 2");
            }
            catch (TreeParsingException e) {
                logger.debug("Failed to make whereExpression", e);
            }
        }
        return var14_27;
    }

    public static WhereExpression mkWhereExprFrmConjunction(Conjunction conjunction, SelectStatement selectStatement) {
        ArrayList<Node> validNodes = new ArrayList<Node>();
        ArrayList<Node> notValidNodes = new ArrayList<Node>();
        for (Node item : conjunction.children) {
            if (WhereExpressionJoinResolver.isValidJoinTerm((BooleanExpressionItem)item)) {
                validNodes.add(item);
                continue;
            }
            notValidNodes.add(item);
        }
        logger.debug("ADDING NOT VALID NODES AT THE END");
        if (notValidNodes.size() != 0) {
            try {
                return new WhereExpression(notValidNodes, selectStatement.builder, selectStatement);
            }
            catch (TreeParsingException e) {
                logger.debug("Failed to make whereExpression", e);
            }
        }
        return null;
    }

    public static JoinExpression makeknownJoin(List<BooleanExpressionItem> conditions, Node left, Node right, SelectStatement selectstatement) {
        ArrayList<OnClauseCondition> onclConditions = new ArrayList<OnClauseCondition>();
        ArrayList<LogicalOperator> logicalOperators = new ArrayList<LogicalOperator>();
        int i = 0;
        for (BooleanExpressionItem booleanExpressionItem : conditions) {
            ColumnReference columnReferenceLeft = (ColumnReference)ColumnReference.class.cast(booleanExpressionItem.getLeft());
            ColumnReference columnReferenceRight = (ColumnReference)ColumnReference.class.cast(booleanExpressionItem.getRight());
            try {
                columnReferenceLeft.setPointedNode(columnReferenceLeft.searchPointedNodeInSubQuery((SubQuery)left));
                if (columnReferenceLeft.getPointedNode() == null) {
                    columnReferenceLeft.setPointedNode(columnReferenceLeft.searchPointedNodeInSubQuery((SubQuery)right));
                }
                columnReferenceRight.setPointedNode(columnReferenceRight.searchPointedNodeInSubQuery((SubQuery)left));
                if (columnReferenceRight.getPointedNode() == null) {
                    columnReferenceRight.setPointedNode(columnReferenceRight.searchPointedNodeInSubQuery((SubQuery)right));
                }
            }
            catch (Exception e) {
                logger.debug("Failed to make Join from the BooleanExpressionItem", e);
            }
            onclConditions.add(new OnClauseCondition(selectstatement.builder, "=", columnReferenceLeft, columnReferenceRight));
            if (++i % 2 != 0) continue;
            logicalOperators.add(LogicalOperator.AND);
        }
        OnClause onClause = new OnClause(selectstatement.builder, onclConditions, logicalOperators);
        return new JoinExpression(selectstatement.builder, left, right, onClause, selectstatement);
    }

    public static boolean isValidJoinTerm(BooleanExpressionItem booleanExpressionItem) {
        if (booleanExpressionItem.left.tokenType == 19 && booleanExpressionItem.right.tokenType == 19 && booleanExpressionItem.comparisonOperator.equals("=")) {
            ColumnReference leftcolref = (ColumnReference)ColumnReference.class.cast(booleanExpressionItem.left);
            ColumnReference rightcolref = (ColumnReference)ColumnReference.class.cast(booleanExpressionItem.right);
            if (leftcolref.getPointedNode().getTokenType() == 53 && rightcolref.getPointedNode().getTokenType() == 53) {
                FunctionCall pfunctionCallLeft = (FunctionCall)FunctionCall.class.cast(leftcolref.getPointedNode());
                FunctionCall pfunctionCallRight = (FunctionCall)FunctionCall.class.cast(rightcolref.getPointedNode());
                if (pfunctionCallLeft.parentNode.equals(pfunctionCallRight.parentNode)) {
                    return false;
                }
            }
            if (leftcolref.getPointedNode().getTokenType() == 19 && rightcolref.getPointedNode().getTokenType() == 19) {
                ColumnCall pColumnCallLeft = (ColumnCall)ColumnCall.class.cast(leftcolref.getPointedNode());
                ColumnCall pColumnCallRight = (ColumnCall)ColumnCall.class.cast(rightcolref.getPointedNode());
                if (pColumnCallLeft.parentNode.equals(pColumnCallRight.parentNode)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void columnResolver(BooleanExpressionItem exprToResolve, SelectStatement caller) {
        UniQueIdContainer PointedNodeInSubQuery;
        List<SubQuery> subQueries = caller.getFromExpression().getSubQueries();
        List<JoinExpression> joinExpressions = caller.getFromExpression().getJoinExpressions();
        if (joinExpressions != null) {
            for (JoinExpression joinExpression : joinExpressions) {
                if (subQueries == null) {
                    subQueries = new ArrayList<SubQuery>();
                }
                subQueries.add((SubQuery)SubQuery.class.cast(joinExpression.getLeftItem()));
                subQueries.add((SubQuery)SubQuery.class.cast(joinExpression.getRightItem()));
            }
        }
        if (exprToResolve.left.tokenType == 19) {
            ColumnReference leftColRef = (ColumnReference)ColumnReference.class.cast(exprToResolve.left);
            if (subQueries != null) {
                for (SubQuery subQuery : subQueries) {
                    try {
                        PointedNodeInSubQuery = leftColRef.searchPointedNodeInSubQuery(subQuery);
                        if (PointedNodeInSubQuery == null) continue;
                        leftColRef.setPointedNode(PointedNodeInSubQuery);
                    }
                    catch (ColumnCallException e) {
                        logger.debug(e);
                    }
                }
            }
        }
        if (exprToResolve.right.tokenType == 19) {
            ColumnReference rightColRef = (ColumnReference)ColumnReference.class.cast(exprToResolve.right);
            if (subQueries != null) {
                for (SubQuery subQuery : subQueries) {
                    try {
                        PointedNodeInSubQuery = rightColRef.searchPointedNodeInSubQuery(subQuery);
                        if (PointedNodeInSubQuery == null) continue;
                        rightColRef.setPointedNode(PointedNodeInSubQuery);
                    }
                    catch (ColumnCallException e) {
                        logger.debug(e);
                    }
                }
            }
        }
    }
}

