% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_and_plot_functions.R
\name{plot_connectivity_precedence}
\alias{plot_connectivity_precedence}
\title{Plot Connectivity vs. Precedence}
\usage{
plot_connectivity_precedence(
  combined_summary,
  file_directory = NULL,
  export = FALSE
)
}
\arguments{
\item{combined_summary}{Data frame with combined summary including categories.}

\item{file_directory}{Directory for saving the output plot. Defaults to NULL.}

\item{export}{Logical indicating whether to export the plot. Defaults to FALSE.}
}
\value{
Invisibly returns a ggplot object.
}
\description{
Create a scatter plot of Connectivity Rank vs. PubMed Rank.
}
\examples{
combined_data <- data.frame(Gene = c("Gene1", "Gene2"), Connectivity_Rank = c(1, 2),
                            PubMed_Rank = c(2, 1),
                            Category = c("High Connectivity - High Precedence", "Other"))
plot_connectivity_precedence(combined_data, export = FALSE)
}
