/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.ColumnHeaderListener;
import org.rosuda.deducer.data.DataViewer;
import org.rosuda.deducer.data.DataViewerTab;
import org.rosuda.deducer.data.ExScrollableTable;
import org.rosuda.deducer.data.ExTable;
import org.rosuda.deducer.data.RDataFrameModel;
import org.rosuda.deducer.toolkit.LoadData;
import org.rosuda.deducer.toolkit.SaveData;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;

public class DataView
extends DataViewerTab
implements ActionListener {
    protected ExTable table;
    protected ExScrollableTable dataScrollPane;
    protected String dataName;

    public DataView(String string) {
        this.init(string);
    }

    protected void init(String string) {
        this.dataName = string;
        RDataFrameModel rDataFrameModel = new RDataFrameModel(string);
        this.table = new ExTable(rDataFrameModel){

            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (eventObject == null || eventObject.getClass().toString().endsWith("KeyEvent")) {
                        if (((JTextComponent)component).getText().equals(RDataFrameModel.NA_STRING)) {
                            ((JTextComponent)component).setText("NA");
                            ((JTextComponent)component).selectAll();
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (((JTextComponent)component).getText().equals(RDataFrameModel.NA_STRING)) {
                                    ((JTextComponent)component).setText("NA");
                                    ((JTextComponent)component).selectAll();
                                }
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.dataScrollPane = new ExScrollableTable(this.table);
        this.dataScrollPane.setRowNamesModel(((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).getRowNamesModel());
        this.dataScrollPane.getExTable().setDefaultRenderer(Object.class, new RDataFrameModel.RCellRenderer(rDataFrameModel));
        this.table.setColumnListener(new DataViewColumnHeaderListener(this.table));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setLayout(new BorderLayout());
        this.add(this.dataScrollPane);
    }

    public void setData(String string) {
        this.dataName = string;
        RDataFrameModel rDataFrameModel = new RDataFrameModel(this.dataName);
        ((RDataFrameModel)this.table.getModel()).removeCachedData();
        this.table.setModel(rDataFrameModel);
        this.dataScrollPane.setRowNamesModel(((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).getRowNamesModel());
        this.dataScrollPane.getExTable().setDefaultRenderer(Object.class, new RDataFrameModel.RCellRenderer(rDataFrameModel));
    }

    public void refresh() {
        boolean bl = ((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).refresh();
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataView.this.dataScrollPane.getRowNamesModel().refresh();
                    DataView.this.dataScrollPane.autoAdjustRowWidth();
                }
            });
        }
    }

    public JMenuBar generateMenuBar() {
        JFrame jFrame = new JFrame();
        String[] stringArray = new String[]{"+", "File", "@NNew Data", "newdata", "@LOpen Data", "loaddata", "@SSave Data", "Save Data", "-", "-", "@PPrint", "print", "~File.Quit", "+", "Edit", "@CCopy", "copy", "@XCut", "cut", "@VPaste", "paste", "-", "Remove Data from Workspace", "Clear Data", "~Window", "+", "Help", "R Help", "help", "~About", "0"};
        JMenuBar jMenuBar = EzMenuSwing.getEzMenu(jFrame, this, stringArray);
        if (!Common.isMac()) {
            EzMenuSwing.addMenuSeparator(jFrame, "Edit");
            EzMenuSwing.addJMenuItem(jFrame, "Help", "About", "about", this);
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                if (!jMenuBar.getMenu(i).getText().equals("About")) continue;
                jMenuBar.remove(i);
                --i;
            }
        }
        return jFrame.getJMenuBar();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string == "Open Data") {
                new LoadData();
            } else if (string == "Save Data") {
                new SaveData(this.dataName);
            } else if (string == "Clear Data") {
                if (this.dataName == null) {
                    JOptionPane.showMessageDialog(this, "Invalid selection: There is no data loaded.");
                    return;
                }
                int n = JOptionPane.showConfirmDialog(null, "Remove Data Frame " + this.dataName + " from environment?\n" + "Unsaved changes will be lost.", "Clear Data Frame", 0, 3);
                if (n == 1) {
                    return;
                }
                Deducer.threadedEval("rm(" + this.dataName + ")");
            } else if (string == "about") {
                new AboutDialog(null);
            } else if (string == "cut") {
                this.table.cutSelection();
            } else if (string == "copy") {
                this.table.copySelection();
            } else if (string == "paste") {
                this.table.pasteSelection();
            } else if (string == "print") {
                try {
                    this.table.print(JTable.PrintMode.NORMAL);
                }
                catch (Exception exception) {}
            } else if (string == "editor") {
                new Editor();
            } else if (string == "exit") {
                ((JFrame)this.getTopLevelAncestor()).dispose();
            } else if (string == "newdata") {
                String string2 = JOptionPane.showInputDialog("Data Name: ");
                if ((string2 = Deducer.getUniqueName(string2)) != null) {
                    new Thread(new Runnable(){

                        public void run() {
                        }
                    }).start();
                    Deducer.threadedEval(string2.trim() + "<-data.frame(Var1=NA)");
                }
            } else if (string == "loaddata") {
                LoadData loadData = new LoadData();
            } else if (string == "help") {
                Deducer.execute("help.start()");
            } else if (string == "table") {
                DataViewer dataViewer = new DataViewer();
                dataViewer.setLocationRelativeTo(null);
                dataViewer.setVisible(true);
            } else if (string == "save") {
                new SaveData(this.dataName);
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void cleanUp() {
        ((RDataFrameModel)this.table.getModel()).removeCachedData();
    }

    public class DataViewColumnHeaderListener
    extends ColumnHeaderListener {
        private ExTable table;
        private JPopupMenu menu;

        public DataViewColumnHeaderListener(ExTable exTable) {
            this.table = exTable;
            JTableHeader jTableHeader = this.table.getTableHeader();
            jTableHeader.addMouseListener(this);
        }

        public void remove() {
            this.table.getTableHeader().removeMouseListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            boolean bl = System.getProperty("java.vendor").indexOf("Apple") > -1;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = this.table.convertColumnIndexToModel(n);
            this.table.selectColumn(n);
            if (mouseEvent.getButton() == 3 && !bl) {
                new ColumnContextMenu(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2 = bl = System.getProperty("java.vendor").indexOf("Apple") > -1;
            if (mouseEvent.isPopupTrigger() && bl) {
                new ColumnContextMenu(mouseEvent);
            }
        }

        public class ColumnContextMenu
        implements ActionListener {
            int vColIndex;
            int mColIndex;

            public ColumnContextMenu(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = DataViewColumnHeaderListener.this.table.getColumnModel();
                this.vColIndex = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                this.mColIndex = DataViewColumnHeaderListener.this.table.convertColumnIndexToModel(this.vColIndex);
                DataViewColumnHeaderListener.this.menu = new JPopupMenu();
                DataViewColumnHeaderListener.this.table.getTableHeader().add(DataViewColumnHeaderListener.this.menu);
                JMenuItem jMenuItem = new JMenuItem("Sort (Increasing)");
                jMenuItem.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem);
                jMenuItem = new JMenuItem("Sort (Decreasing)");
                jMenuItem.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem);
                DataViewColumnHeaderListener.this.menu.add(new JSeparator());
                JMenuItem jMenuItem2 = new JMenuItem("Copy");
                jMenuItem2.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem2);
                JMenuItem jMenuItem3 = new JMenuItem("Cut");
                jMenuItem3.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem3);
                JMenuItem jMenuItem4 = new JMenuItem("Paste");
                jMenuItem4.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem4);
                JMenuItem jMenuItem5 = new JMenuItem("Paste into New");
                jMenuItem5.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem5);
                DataViewColumnHeaderListener.this.menu.addSeparator();
                JMenuItem jMenuItem6 = new JMenuItem("Insert Empty");
                jMenuItem6.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem6);
                JMenuItem jMenuItem7 = new JMenuItem("Duplicate");
                jMenuItem7.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem7);
                JMenuItem jMenuItem8 = new JMenuItem("Remove");
                jMenuItem8.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem8);
                DataViewColumnHeaderListener.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                final JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                final int n = this.vColIndex;
                new Thread(new Runnable(){

                    public void run() {
                        if (jMenuItem.getText() == "Copy") {
                            DataViewColumnHeaderListener.this.table.getCopyPasteAdapter().copy();
                        } else if (jMenuItem.getText() == "Cut") {
                            DataViewColumnHeaderListener.this.table.cutColumn(n);
                        } else if (jMenuItem.getText() == "Paste") {
                            DataViewColumnHeaderListener.this.table.getCopyPasteAdapter().paste();
                        } else if (jMenuItem.getText() == "Paste into New") {
                            DataViewColumnHeaderListener.this.table.insertColumn(n);
                        } else if (jMenuItem.getText() == "Insert Empty") {
                            DataViewColumnHeaderListener.this.table.insertNewColumn(n);
                        } else if (jMenuItem.getText() == "Remove") {
                            DataViewColumnHeaderListener.this.table.removeColumn(n);
                        } else if (jMenuItem.getText().equals("Sort (Increasing)")) {
                            String string = ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + " <- sort(" + ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + ", by=~" + DataViewColumnHeaderListener.this.table.getColumnName(n).trim() + ")";
                            Deducer.eval(string);
                            DataView.this.refresh();
                        } else if (jMenuItem.getText().equals("Sort (Decreasing)")) {
                            String string = ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + " <- sort(" + ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + ", by=~ -" + DataViewColumnHeaderListener.this.table.getColumnName(n).trim() + ")";
                            Deducer.eval(string);
                            DataView.this.refresh();
                        } else if (jMenuItem.getText().equals("Duplicate")) {
                            int n2 = n + 1;
                            String string = ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + " <- cbind(" + ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + "[,1:" + n2 + "]," + ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + "[," + n2 + "]," + ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + "[," + n2 + ":ncol(" + ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + ")])";
                            Deducer.eval(string);
                            Deducer.eval("names(" + ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + ")[" + (n2 + 1) + "] <- " + "paste(names(" + ((DataViewColumnHeaderListener)((ColumnContextMenu)ColumnContextMenu.this).DataViewColumnHeaderListener.this).DataView.this.dataName + ")[" + n2 + "],'1',sep='')");
                            DataView.this.refresh();
                        }
                    }
                }).start();
                DataViewColumnHeaderListener.this.menu.setVisible(false);
            }
        }
    }
}

