/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JGR.util.TableSorter;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.Loader;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarDouble;
import org.rosuda.ibase.SVarFact;
import org.rosuda.ibase.SVarInt;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.SVarSet;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class DataTable
extends TJFrame
implements ActionListener,
MouseListener,
KeyListener {
    private static final long serialVersionUID = 4257267810053816420L;
    private final GridBagLayout layout = new GridBagLayout();
    private final JScrollPane scrollArea = new JScrollPane();
    private final JTable dataTable = new JTable();
    private final JTableHeader tableHeader = this.dataTable.getTableHeader();
    private final JButton save = new JButton();
    private SVarSet vs;
    private DataTableModel tabModel;
    private DataTableColumnModel columnModel;
    private final DataTableCellEditor cell = new DataTableCellEditor();
    private TableSorter sorter;
    private static int selectedColumn = -1;
    private static final int[] searchIndex = new int[]{-1, -1};
    private static String searchString = "";
    private String fileName = null;
    private boolean modified = false;
    private String type = "data.frame";
    private boolean editable = true;
    private boolean rownames = false;

    public DataTable() {
        this(null, null, true);
    }

    public DataTable(SVarSet sVarSet, String string, boolean bl) {
        this(sVarSet, string, bl, true);
    }

    public DataTable(SVarSet sVarSet, String string, boolean bl, boolean bl2) {
        super("DataTable Editor", false, 153);
        if (sVarSet == null) {
            sVarSet = new SVarSet();
            sVarSet.setName("NewDataTable");
            this.save.setText("Save");
            this.save.setToolTipText("Save");
            this.save.setActionCommand("saveData");
        } else {
            this.save.setText("Update");
            this.save.setToolTipText("Update");
            this.save.setActionCommand("export");
            this.setTitle("DataTable - " + sVarSet.getName().replaceFirst("jgr_temp", ""));
            if (string != null) {
                this.type = string;
            }
        }
        this.vs = sVarSet;
        this.editable = bl;
        this.save.setEnabled(bl);
        String[] stringArray = new String[]{"+", "File", "@OOpen", "loadData", "@SSave", "saveData", "!SSave as", "saveDataAs", "Export to R", "export", "~File.Basic.End", "+", "Edit", "@XCut", "cut", "@CCopy", "copy", "@VPaste", "paste", "Delete", "delete", "@ASelect All", "selAll", "-", "@FFind", "search", "@GFind Next", "searchnext", "+", "Tools", "Add Column", "addCol", "Remove Column", "rmCol", "Add Row", "addRow", "Remove Row", "rmRow", "-", "-", "Goto Case", "gotoCase", "~Window", "+", "Help", "R Help", "rhelp", "~Preferences", "~About", "0"};
        EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)this, (String[])stringArray);
        if (FontTracker.current == null) {
            FontTracker.current = new FontTracker();
        }
        FontTracker.current.add(this.dataTable);
        this.save.addActionListener(this);
        this.dataTable.setAutoResizeMode(0);
        this.columnModel = new DataTableColumnModel(this);
        this.dataTable.setFont(JGRPrefs.DefaultFont);
        this.dataTable.setColumnModel(this.columnModel);
        this.tabModel = new DataTableModel(this);
        this.sorter = new TableSorter(this.tabModel);
        this.dataTable.setModel(this.sorter);
        this.sorter.setTableHeader(this.tableHeader);
        this.dataTable.setShowGrid(true);
        this.dataTable.setRowHeight((int)((double)JGRPrefs.FontSize * 1.6));
        this.dataTable.setColumnSelectionAllowed(true);
        this.dataTable.setRowSelectionAllowed(true);
        this.dataTable.setCellSelectionEnabled(true);
        this.dataTable.addMouseListener(this);
        this.dataTable.addKeyListener(this);
        this.tableHeader.addMouseListener(this);
        this.cell.getComponent().addMouseListener(this);
        this.cell.getComponent().addKeyListener(this);
        this.scrollArea.setWheelScrollingEnabled(true);
        this.scrollArea.getViewport().add(this.dataTable);
        this.getContentPane().setLayout(this.layout);
        this.getContentPane().add((Component)new JScrollPane(this.dataTable), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.getContentPane().add((Component)this.save, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 5, 10), 0, 0));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DataTable.this.exit();
            }
        });
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.setLocation(this.getLocation().x, 10);
        int n = this.dataTable.getRowHeight();
        int n2 = this.dataTable.getRowCount();
        int n3 = this.dataTable.getColumnCount();
        int n4 = n3 * 75;
        int n5 = (int)((double)(n2 * n) * 1.6);
        Dimension dimension = new Dimension(n4 < 400 && n3 < 2 ? 400 : n4, n5 < 400 && n2 < 11 ? 300 : n5);
        this.setSize(new Dimension(dimension.width > Common.screenRes.width ? Common.screenRes.width - 50 : dimension.width, dimension.height > Common.screenRes.height ? Common.screenRes.height - 50 : dimension.height));
        this.setLocation(this.getLocation().x + 100, 10);
        this.initPlacement();
        if (bl2) {
            this.setVisible(true);
        }
    }

    private void addColumn() {
        this.modified = true;
        String[] stringArray = new NewColumnDialog((Frame)((Object)this)).showInputDialog();
        String[] stringArray2 = new String[]{"Numeric (double)", "Numeric (integer)", "Factor", "Character"};
        if (stringArray != null) {
            SVarDouble sVarDouble;
            if (stringArray[1].equals(stringArray2[0])) {
                sVarDouble = new SVarDouble(null, this.dataTable.getRowCount());
            } else if (stringArray[1].equals(stringArray2[1])) {
                sVarDouble = new SVarInt(null, this.dataTable.getRowCount());
            } else if (stringArray[1].equals(stringArray2[3])) {
                sVarDouble = new SVarObj(null, false);
                sVarDouble.setAllEmpty(this.dataTable.getRowCount());
            } else {
                sVarDouble = new SVarFact(null, this.dataTable.getRowCount());
            }
            if (stringArray[0].equals("")) {
                this.vs.insert(selectedColumn < 1 ? this.tabModel.cols - 1 : selectedColumn, (SVar)sVarDouble);
            } else {
                this.vs.insert(stringArray[0], selectedColumn < 1 ? this.tabModel.cols - 1 : selectedColumn, (SVar)sVarDouble);
            }
            this.refresh();
        }
    }

    private void addRow() {
        this.modified = true;
        int n = this.currentRow();
        n = n == -1 ? this.tabModel.rows - 1 : n;
        this.vs.insertCaseAt(n + 1);
        this.refresh();
    }

    public int currentCol() {
        return this.dataTable.getSelectedColumn();
    }

    public int currentCol(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.tableHeader)) {
            return this.tableHeader.columnAtPoint(mouseEvent.getPoint());
        }
        return this.dataTable.getSelectedColumn() == -1 ? this.tableHeader.columnAtPoint(mouseEvent.getPoint()) : this.dataTable.getSelectedColumn();
    }

    public int[] currentCols() {
        return this.dataTable.getSelectedColumns();
    }

    public int currentRow() {
        return this.dataTable.getSelectedRow();
    }

    public int[] currentRows() {
        return this.dataTable.getSelectedRows();
    }

    private void deleteContent(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            for (int j = 0; j < nArray2.length; ++j) {
                this.vs.at(nArray[i] - 1).replace(nArray2[j], null);
            }
        }
        this.refresh();
    }

    public void exit() {
        if (this.modified && this.editable) {
            if (this.save.getText() == "Save") {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Save data?", "Exit", 1, 3);
                if (n == 1) {
                    super.dispose();
                } else if (n == 0 && this.saveData()) {
                    super.dispose();
                }
            } else {
                this.export(true);
            }
        } else {
            super.dispose();
        }
    }

    private void find(int n, int n2) {
        if (searchString == "" || n2 == -1) {
            searchString = JOptionPane.showInputDialog(new JTextField(), "Search:", "Search for:", -1);
        }
        if (searchString != null) {
            int[] nArray = this.vs.whereis((Object)searchString, n == -1 ? 0 : n, n2 == -1 ? 0 : n2);
            if (nArray[0] == -1 && nArray[1] == -1) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Not found", "Result", 2);
            } else {
                nArray[1] = this.sorter.modelIndex(nArray[1]);
                this.gotoCell(nArray[0] + 1, nArray[1]);
            }
            DataTable.searchIndex[0] = nArray[0];
            if (nArray[0] + 1 == this.tabModel.cols - 1) {
                DataTable.searchIndex[0] = -1;
                DataTable.searchIndex[1] = nArray[1] + 1;
            } else {
                DataTable.searchIndex[0] = nArray[0] + 1;
                DataTable.searchIndex[1] = nArray[1];
            }
        }
    }

    private void gotoCase(int n) {
        String string = null;
        JScrollBar jScrollBar = this.scrollArea.getVerticalScrollBar();
        int n2 = this.dataTable.getRowHeight();
        if (n == -1) {
            string = JOptionPane.showInputDialog(new JTextField(), "Goto Case:", "Goto Case", -1);
        }
        if (string != null) {
            try {
                int n3 = n == -1 ? Integer.parseInt(string) - 1 : n;
                this.dataTable.setRowSelectionInterval(n3, n3);
                this.dataTable.setColumnSelectionInterval(0, this.tabModel.cols - 1);
                jScrollBar.setValue(n3 * n2 - jScrollBar.getVisibleAmount() + 10 < 0 ? 0 : n3 * n2 - jScrollBar.getVisibleAmount() + n2 + 10);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private void gotoCell(int n, int n2) {
        int n3 = this.dataTable.getRowHeight();
        this.dataTable.setRowSelectionInterval(n2, n2);
        JScrollBar jScrollBar = this.scrollArea.getVerticalScrollBar();
        jScrollBar.setValue(n2 * n3 - jScrollBar.getVisibleAmount() + 10 < 0 ? 0 : n2 * n3 - jScrollBar.getVisibleAmount() + n3 + 10);
        this.dataTable.setColumnSelectionInterval(n, n);
        JScrollBar jScrollBar2 = this.scrollArea.getHorizontalScrollBar();
        jScrollBar2.setValue(n * 75 - jScrollBar2.getVisibleAmount() + 30 < 0 ? 0 : n * 75 - jScrollBar2.getVisibleAmount() + 75 + 10);
    }

    public JTable getJTable() {
        return this.dataTable;
    }

    private void loadData() {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), "Open...", 0, JGRPrefs.workingDirectory);
        fileSelector.setVisible(true);
        if (fileSelector.getFile() != null) {
            this.setWorking(true);
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            this.fileName = JGRPrefs.workingDirectory + fileSelector.getFile();
            try {
                this.vs = new SVarSet();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileName));
                Loader.LoadTSV((BufferedReader)bufferedReader, (SVarSet)this.vs, (boolean)true);
                bufferedReader.close();
                this.vs.setMarker(new SMarker(this.vs.at(0).size()));
                this.vs.setName(this.fileName);
                this.setTitle("DataTable - " + this.vs.getName());
                this.refresh();
                this.dataTable.setModel(this.sorter);
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
            this.setWorking(false);
        }
    }

    private void moveColumnsSVar(int n, int n2) {
        this.vs.move(n - 1, n2 - 1);
        this.refresh();
    }

    private void refresh() {
        int n = this.sorter.getSortingStatus();
        int n2 = this.sorter.getSortedColumn();
        this.tabModel = new DataTableModel(this);
        this.sorter = new TableSorter(this.tabModel);
        this.dataTable.setModel(this.sorter);
        this.sorter.setTableHeader(this.tableHeader);
        this.sorter.setSortingStatus(n2, n);
    }

    private void renameColumn(int n) {
        String string = this.vs.at(n - 1).getName();
        String string2 = (String)JOptionPane.showInputDialog(new JTextField(), "Rename Column into:", "Rename Column", -1, null, null, string);
        if (string2 != null) {
            this.vs.at(n - 1).setName(string2);
            this.refresh();
        }
    }

    private void removeColumns() {
        int[] nArray = this.currentCols();
        if (nArray.length == 0) {
            nArray = new int[]{selectedColumn};
            if (this.dataTable.getColumnName(selectedColumn).equals("row.names")) {
                return;
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            this.vs.remove(nArray[i] - 1 - i);
        }
        this.refresh();
    }

    private void removeRows() {
        int[] nArray = this.currentRows();
        for (int i = nArray.length; i > 0; --i) {
            this.vs.removeCaseAt(this.sorter.modelIndex(nArray[i - 1]));
        }
        this.refresh();
    }

    private void export(boolean bl) {
        JTextField jTextField = new JTextField(this.vs.getName());
        jTextField.setMinimumSize(new Dimension(150, 20));
        jTextField.setPreferredSize(new Dimension(150, 20));
        jTextField.setMaximumSize(new Dimension(150, 20));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Export as: "), "Center");
        jPanel.add((Component)jTextField, "South");
        int n = JOptionPane.showOptionDialog((Component)((Object)this), jPanel, "Export to R?", 1, 3, null, null, this.vs.getName());
        String string = jTextField.getText();
        if (n == 2) {
            return;
        }
        if (n == 1 && string != null && bl) {
            super.dispose();
        } else if (n == 0 && string != null && string.trim().length() > 0) {
            this.vs.setName(string.trim());
            boolean bl2 = RController.export(this.vs, this.type);
            if (bl) {
                if (bl2) {
                    super.dispose();
                } else if (JOptionPane.showConfirmDialog((Component)((Object)this), "Export to R is not supported\nExit Anyway?", "Export Error", 0, 0) == 0) {
                    this.dispose();
                }
            } else if (!bl2) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Export to R is not supported", "Export Error", 0);
            }
        }
        this.modified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveData() {
        if (this.fileName == null) return this.saveDataAs();
        if (this.fileName.equals("")) {
            return this.saveDataAs();
        }
        this.setWorking(true);
        BufferedWriter bufferedWriter = null;
        String string = "";
        try {
            try {
                int n;
                bufferedWriter = new BufferedWriter(new FileWriter(this.fileName));
                int n2 = this.vs.count();
                for (n = 0; n < n2 - 1; ++n) {
                    if (this.vs.at(n).getName().equals("row.names")) {
                        bufferedWriter.write(" ");
                        continue;
                    }
                    bufferedWriter.write("" + this.vs.at(n).getName() + "\t");
                }
                bufferedWriter.write("" + this.vs.at(n2 - 1).getName() + "\n");
                bufferedWriter.flush();
                for (n = 0; n < this.vs.length(); ++n) {
                    for (int i = 0; i < n2 - 1; ++i) {
                        string = this.vs.at(i).at(n) == null ? " " : this.vs.at(i).at(n).toString();
                        bufferedWriter.write("" + string + "\t");
                    }
                    string = this.vs.at(n2 - 1).at(n) == null ? " " : this.vs.at(n2 - 1).at(n).toString();
                    bufferedWriter.write("" + string + "\n");
                    bufferedWriter.flush();
                }
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
                Object var7_8 = null;
                this.setWorking(false);
                this.modified = false;
                return true;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.setWorking(false);
            this.modified = false;
            throw throwable;
        }
        this.setWorking(false);
        this.modified = false;
        return true;
    }

    private boolean saveDataAs() {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), "Save as...", 1, JGRPrefs.workingDirectory);
        fileSelector.setVisible(true);
        if (fileSelector.getFile() != null) {
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            this.fileName = JGRPrefs.workingDirectory + fileSelector.getFile();
            return this.saveData();
        }
        return false;
    }

    private void popUpMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        JMenuItem jMenuItem4 = new JMenuItem();
        JMenuItem jMenuItem5 = new JMenuItem();
        JMenuItem jMenuItem6 = new JMenuItem();
        JMenuItem jMenuItem7 = new JMenuItem();
        JMenuItem jMenuItem8 = new JMenuItem();
        JMenuItem jMenuItem9 = new JMenuItem();
        jMenuItem.setToolTipText("Rename Column");
        jMenuItem.setActionCommand("renameCol");
        jMenuItem.setText("Rename Column");
        jMenuItem.addActionListener(this);
        jMenuItem2.setToolTipText("Insert Column");
        jMenuItem2.setActionCommand("addCol");
        jMenuItem2.setText("Insert Column");
        jMenuItem2.addActionListener(this);
        jMenuItem3.setToolTipText("Remove Column");
        jMenuItem3.setActionCommand("rmCol");
        jMenuItem3.setText("Remove Column");
        jMenuItem3.addActionListener(this);
        jMenuItem4.setToolTipText("Insert Row");
        jMenuItem4.setActionCommand("addRow");
        jMenuItem4.setText("Insert Row");
        jMenuItem4.addActionListener(this);
        jMenuItem5.setActionCommand("rmRow");
        jMenuItem5.setText("Remove Row");
        jMenuItem5.setToolTipText("Remove Row");
        jMenuItem5.addActionListener(this);
        jMenuItem9.setToolTipText("Cut");
        jMenuItem9.setActionCommand("cut");
        jMenuItem9.setText("Cut");
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        jMenuItem9.addActionListener(this);
        jMenuItem8.setToolTipText("Copy");
        jMenuItem8.setActionCommand("copy");
        jMenuItem8.setText("Copy");
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        jMenuItem8.addActionListener(this);
        jMenuItem6.setToolTipText("Paste");
        jMenuItem6.setActionCommand("paste");
        jMenuItem6.setText("Paste");
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        jMenuItem6.addActionListener(this);
        jMenuItem7.setEnabled(false);
        jPopupMenu.add(jMenuItem7);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem9);
        jPopupMenu.add(jMenuItem8);
        jPopupMenu.add(jMenuItem6);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.add(jMenuItem5);
        if (!mouseEvent.getSource().equals(this.cell.getComponent())) {
            jMenuItem9.setEnabled(false);
            jMenuItem8.setEnabled(false);
            jMenuItem6.setEnabled(false);
            if (mouseEvent.getSource().equals(this.tableHeader)) {
                jMenuItem.setEnabled(true);
                jMenuItem2.setEnabled(true);
                jMenuItem3.setEnabled(true);
                if (this.currentCol(mouseEvent) == 0) {
                    jMenuItem4.setEnabled(true);
                    jMenuItem5.setEnabled(true);
                } else {
                    jMenuItem4.setEnabled(false);
                    jMenuItem5.setEnabled(false);
                }
            } else {
                if (this.dataTable.getSelectedRowCount() == this.tabModel.rows) {
                    jMenuItem.setEnabled(true);
                    jMenuItem2.setEnabled(true);
                    jMenuItem3.setEnabled(true);
                } else {
                    jMenuItem.setEnabled(false);
                    jMenuItem2.setEnabled(false);
                    jMenuItem3.setEnabled(false);
                }
                if (this.currentCol(mouseEvent) == 0) {
                    jMenuItem4.setEnabled(true);
                    jMenuItem5.setEnabled(true);
                } else {
                    jMenuItem4.setEnabled(false);
                    jMenuItem5.setEnabled(false);
                }
            }
        } else {
            jMenuItem9.setEnabled(true);
            jMenuItem8.setEnabled(true);
            jMenuItem6.setEnabled(true);
            jMenuItem.setEnabled(false);
            jMenuItem2.setEnabled(false);
            jMenuItem3.setEnabled(false);
            jMenuItem4.setEnabled(false);
            jMenuItem5.setEnabled(false);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string == "about") {
                new AboutDialog((JFrame)((Object)this));
            } else if (string == "addCol") {
                this.addColumn();
            } else if (string == "addRow") {
                this.addRow();
            } else if (string == "cut") {
                ((JTextComponent)this.cell.getComponent()).cut();
            } else if (string == "copy") {
                ((JTextComponent)this.cell.getComponent()).copy();
            } else if (string == "delete") {
                this.deleteContent(this.dataTable.getSelectedColumns(), this.dataTable.getSelectedRows());
            } else if (string == "exit") {
                this.exit();
            } else if (string == "export") {
                this.export(false);
            } else if (string == "search") {
                this.find(-1, -1);
            } else if (string == "searchnext") {
                this.find(searchIndex[0], searchIndex[1]);
            } else if (string == "gotoCase") {
                this.gotoCase(-1);
            } else if (string == "loadData") {
                this.loadData();
            } else if (string == "help") {
                JGR.MAINRCONSOLE.execute("help.start()", false);
            } else if (string == "paste") {
                ((JTextComponent)this.cell.getComponent()).paste();
            } else if (string == "renameCol" && selectedColumn > 0) {
                this.renameColumn(selectedColumn);
            } else if (string == "rmCol") {
                this.removeColumns();
            } else if (string == "rmRow") {
                this.removeRows();
            } else if (string == "saveData") {
                this.saveData();
            } else if (string == "saveDataAs") {
                this.saveDataAs();
            } else if (string == "selAll") {
                this.dataTable.selectAll();
            } else if (string == "preferences") {
                PrefDialog.showPreferences((JFrame)((Object)this));
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 && (this.dataTable.getSelectedColumnCount() > 1 || this.dataTable.getSelectedRowCount() > 1)) {
            this.deleteContent(this.dataTable.getSelectedColumns(), this.dataTable.getSelectedRows());
        } else if (keyEvent.getKeyCode() == 114) {
            this.find(searchIndex[0], searchIndex[1]);
        } else if (keyEvent.getKeyCode() == 10 && this.dataTable.getSelectedRow() == this.tabModel.rows - 1 && this.dataTable.getSelectedColumn() == this.tabModel.cols - 1) {
            if (this.editable && this.dataTable.isEditing()) {
                this.tabModel.setValueAt(((JTextComponent)this.cell.getComponent()).getText(), this.dataTable.getSelectedRow(), this.dataTable.getSelectedColumn());
            }
            this.addRow();
            this.tabModel.fireTableStructureChanged();
        } else if (this.editable && keyEvent.getKeyCode() == 9 && this.dataTable.getSelectedRow() == 0 && this.dataTable.getSelectedColumn() == this.tabModel.cols - 1 && !keyEvent.isShiftDown()) {
            if (this.dataTable.isEditing()) {
                this.tabModel.setValueAt(((JTextComponent)this.cell.getComponent()).getText(), this.dataTable.getSelectedRow(), this.dataTable.getSelectedColumn());
            }
            selectedColumn = -1;
            this.addColumn();
            this.tabModel.fireTableStructureChanged();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.modified = this.dataTable.getSelectedColumn() > 0;
        try {
            selectedColumn = this.currentCol(mouseEvent);
            if (mouseEvent.getSource().equals(this.tableHeader)) {
                int n = this.dataTable.columnAtPoint(mouseEvent.getPoint());
                if (n != 0 && mouseEvent.isPopupTrigger()) {
                    this.popUpMenu(mouseEvent);
                } else if (mouseEvent.getClickCount() == 2 && selectedColumn > 0 && !this.dataTable.getColumnName(selectedColumn).equals("row.names")) {
                    this.renameColumn(selectedColumn);
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.popUpMenu(mouseEvent);
            } else if (selectedColumn == 0) {
                this.dataTable.setColumnSelectionInterval(0, this.tabModel.cols - 1);
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            int n;
            if (mouseEvent.getSource().equals(this.tableHeader)) {
                String string = this.dataTable.getColumnName(this.dataTable.columnAtPoint(mouseEvent.getPoint()));
                n = this.dataTable.columnAtPoint(mouseEvent.getPoint());
                if (n != 0 && string != "row.names" && mouseEvent.isPopupTrigger()) {
                    this.popUpMenu(mouseEvent);
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.popUpMenu(mouseEvent);
            }
            int n2 = this.dataTable.getColumn(this.dataTable.getColumnName(selectedColumn)).getModelIndex();
            n = selectedColumn;
            if (n2 != 0 && n != 0 && (!this.rownames || n2 != 1 && n != 1) && n2 != n) {
                this.moveColumnsSVar(n2, n);
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class MarkerSelectionModel
    implements ListSelectionModel,
    Dependent {
        SMarker m;
        Vector ls;
        int anchor;
        int lead;
        boolean isadj = false;

        MarkerSelectionModel(SMarker sMarker) {
            this.m = sMarker;
            this.ls = new Vector();
            this.m.addDepend((Dependent)this);
        }

        protected void finalize() {
            if (this.m != null) {
                this.m.delDepend((Dependent)this);
            }
            this.ls.removeAllElements();
            this.m = null;
        }

        public void Notifying(NotifyMsg notifyMsg, Object object, Vector vector) {
            ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, 0, this.m.size(), false);
            for (int i = 0; i < this.ls.size(); ++i) {
                ((ListSelectionListener)this.ls.elementAt(i)).valueChanged(listSelectionEvent);
            }
        }

        public void setSelectionInterval(int n, int n2) {
            this.m.selectNone();
            this.addSelectionInterval(n, n2);
        }

        public void addSelectionInterval(int n, int n2) {
            int n3;
            this.anchor = n;
            this.lead = n2;
            int n4 = n < n2 ? n : n2;
            int n5 = n3 = n < n2 ? n2 : n;
            while (n4 <= n3) {
                this.m.set(n4++, true);
            }
            this.m.NotifyAll(new NotifyMsg((Object)this.m, 4096));
        }

        public void removeSelectionInterval(int n, int n2) {
            int n3;
            int n4 = n < n2 ? n : n2;
            int n5 = n3 = n < n2 ? n2 : n;
            while (n4 <= n3) {
                this.m.set(n4++, false);
            }
            this.m.NotifyAll(new NotifyMsg((Object)this.m, 4096));
        }

        public int getMinSelectionIndex() {
            if (this.isSelectionEmpty()) {
                return -1;
            }
            int n = this.m.size();
            for (int i = 0; i < n; ++i) {
                if (!this.m.at(i)) continue;
                return i;
            }
            return -1;
        }

        public int getMaxSelectionIndex() {
            if (this.isSelectionEmpty()) {
                return -1;
            }
            for (int i = this.m.size() - 1; i >= 0; --i) {
                if (!this.m.at(i)) continue;
                return i;
            }
            return -1;
        }

        public boolean isSelectedIndex(int n) {
            return this.m.at(n);
        }

        public int getAnchorSelectionIndex() {
            return this.anchor;
        }

        public void setAnchorSelectionIndex(int n) {
            this.anchor = n;
        }

        public int getLeadSelectionIndex() {
            return this.lead;
        }

        public void setLeadSelectionIndex(int n) {
            if (n == this.lead) {
                return;
            }
            if (n >= this.anchor) {
                if (this.lead < this.anchor) {
                    this.removeSelectionInterval(this.lead, this.anchor - 1);
                }
                if (n < this.lead) {
                    this.removeSelectionInterval(n + 1, this.lead);
                    this.lead = n;
                } else {
                    this.addSelectionInterval(this.anchor, n);
                }
            } else {
                if (this.lead > this.anchor) {
                    this.removeSelectionInterval(this.anchor + 1, this.lead);
                }
                if (n > this.lead) {
                    this.removeSelectionInterval(this.lead, n - 1);
                    this.lead = n;
                } else {
                    this.addSelectionInterval(this.anchor, n);
                }
            }
        }

        public void clearSelection() {
            this.m.selectNone();
            this.m.NotifyAll(new NotifyMsg((Object)this.m, 4096));
        }

        public boolean isSelectionEmpty() {
            return this.m.marked() == 0;
        }

        public void insertIndexInterval(int n, int n2, boolean bl) {
        }

        public void removeIndexInterval(int n, int n2) {
        }

        public void setValueIsAdjusting(boolean bl) {
            this.isadj = bl;
        }

        public boolean getValueIsAdjusting() {
            return this.isadj;
        }

        public void setSelectionMode(int n) {
        }

        public int getSelectionMode() {
            return 2;
        }

        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.ls.addElement(listSelectionListener);
        }

        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
            this.ls.removeElement(listSelectionListener);
        }
    }

    class NewColumnDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 176433470901874606L;
        String[] varType;
        String[] result;
        JComboBox typeChooser;
        JTextField name;
        JButton cancel;
        JButton ok;

        public NewColumnDialog(Frame frame) {
            super(frame, "Add Column", true);
            this.varType = new String[]{"Numeric (double)", "Numeric (integer)", "Factor", "Character"};
            this.result = null;
            this.typeChooser = new JComboBox<String>(this.varType);
            this.name = new JTextField();
            this.cancel = new JButton("Cancel");
            this.ok = new JButton("Ok");
            this.cancel.setActionCommand("cancel");
            this.ok.setActionCommand("ok");
            this.cancel.addActionListener(this);
            this.ok.addActionListener(this);
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)this.name, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 2, 5), 0, 0));
            this.getContentPane().add((Component)this.typeChooser, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 1, new Insets(2, 5, 2, 5), 0, 0));
            this.getContentPane().add((Component)this.cancel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 50, 2, 5), 0, 0));
            this.getContentPane().add((Component)this.ok, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            this.setDefaultCloseOperation(2);
            this.getRootPane().setDefaultButton(this.ok);
            this.setResizable(false);
            this.setSize(250, 120);
            this.setLocation(frame.getLocation().x + (frame.getWidth() / 2 - 125), frame.getLocation().y + (frame.getHeight() / 2 - 60));
        }

        public String[] showInputDialog() {
            this.setVisible(true);
            return this.result;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == "cancel") {
                this.dispose();
            } else if (string == "ok") {
                this.result = new String[2];
                this.result[0] = this.name.getText();
                this.result[1] = this.typeChooser.getSelectedItem().toString();
                this.dispose();
            }
        }
    }

    class DataTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 3439613828130597094L;

        DataTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                // empty if block
            }
            if (bl2) {
                // empty if block
            }
            this.setText(object.toString());
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    class DataTableCellDocument
    extends PlainDocument {
        private static final long serialVersionUID = 3679382895962869038L;

        DataTableCellDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            try {
                if (DataTable.this.vs.at(DataTable.this.dataTable.getSelectedColumn() - 1).isNum() && !string.matches("[+|-]*[[0-9]+.[0-9]+]*[0-9]*")) {
                    string = "";
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
            super.insertString(n, string, attributeSet);
        }
    }

    class DataTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -4264723305967926901L;
        JTextField component;

        DataTableCellEditor() {
            this.component = new JTextField(new DataTableCellDocument(), null, 1);
        }

        public Component getComponent() {
            return this.component;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            DataTable.this.dataTable.setColumnSelectionInterval(n2, n2);
            this.component.setText(object.toString().equals("NA") ? "" : object.toString());
            return this.component;
        }

        public Object getCellEditorValue() {
            return this.component.getText();
        }
    }

    class DataTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 6682943116161132225L;
        DataTable tab;
        int cols;
        int rows;

        DataTableModel(DataTable dataTable2) {
            this.tab = dataTable2;
            if (dataTable2.vs == null || dataTable2.vs.count() == 0) {
                this.cols = 1;
                this.rows = 1;
            } else {
                this.cols = DataTable.this.vs.count() + 1;
                this.rows = DataTable.this.vs.at(0).size();
            }
        }

        public int getColumnCount() {
            return this.cols;
        }

        public int getRowCount() {
            return this.rows;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = new Integer(n + 1);
            } else if (DataTable.this.vs != null) {
                try {
                    object = this.tab.vs.at(n2 - 1).at(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object == null ? "NA" : object;
        }

        public void setValueAt(Object object, int n, int n2) {
            try {
                if (object.toString().equals("") || object.toString().equals("NA")) {
                    object = null;
                }
                if (DataTable.this.vs.at(n2 - 1).isNum()) {
                    if (object != null) {
                        if (object.toString().indexOf(".") != -1) {
                            this.tab.vs.at(n2 - 1).replace(n, Double.parseDouble(object.toString()));
                        } else {
                            this.tab.vs.at(n2 - 1).replace(n, Integer.parseInt(object.toString()));
                        }
                    } else if (this.tab.vs.at(n2 - 1).getClass().getName().equals("org.rosuda.ibase.SVarDouble")) {
                        this.tab.vs.at(n2 - 1).replace(n, SVar.double_NA);
                    } else if (this.tab.vs.at(n2 - 1).getClass().getName().equals("org.rosuda.ibase.SVarInt")) {
                        this.tab.vs.at(n2 - 1).replace(n, SVar.int_NA);
                    } else {
                        this.tab.vs.at(n2 - 1).replace(n, Double.NaN);
                    }
                } else if (this.tab.vs.at(n2 - 1).getClass().getName().equals("org.rosuda.ibase.SVarFact")) {
                    this.tab.vs.at(n2 - 1).replace(n, object == null ? "NA" : object);
                } else {
                    this.tab.vs.at(n2 - 1).replace(n, object);
                }
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }

        public String getColumnName(int n) {
            String string = new String(" ");
            if (this.tab.vs != null && n != 0) {
                try {
                    string = this.tab.vs.at(n - 1).getName();
                }
                catch (Exception exception) {
                    return "C " + n;
                }
            }
            return string == "" ? "C " + n : string;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 ? false : DataTable.this.editable;
        }
    }

    class DataTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -3297048934317912993L;

        public DataTableColumnModel(DataTable dataTable2) {
        }

        public void addColumn(TableColumn tableColumn) {
            DataTable.this.cell.getComponent().setFont(JGRPrefs.DefaultFont);
            FontTracker.current.add((JTextComponent)DataTable.this.cell.getComponent());
            tableColumn.setCellEditor(DataTable.this.cell);
            tableColumn.setCellRenderer(new DefaultTableCellRenderer());
            if (tableColumn.getModelIndex() == 0) {
                tableColumn.setMaxWidth(40);
            }
            if (tableColumn.getHeaderValue().equals("row.names")) {
                DataTable.this.rownames = true;
                DataTable.this.dataTable.getColumnModel().getColumn(0).setMaxWidth(0);
                DataTable.this.dataTable.getColumnModel().getColumn(0).setMinWidth(0);
                DataTable.this.dataTable.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
                DataTable.this.dataTable.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
            }
            tableColumn.setMinWidth(50);
            super.addColumn(tableColumn);
        }

        public TableColumn getColumn(int n) {
            return super.getColumn(n < 0 ? 0 : n);
        }

        public void moveColumn(int n, int n2) {
            if (n < 0 || n >= this.getColumnCount() || n2 < 0 || n2 >= this.getColumnCount()) {
                return;
            }
            super.moveColumn(n, n2);
            if (n == 0 || n2 == 0 || DataTable.this.rownames && (n == 1 || n2 == 1)) {
                super.moveColumn(n2, n);
            }
        }
    }
}

