/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.plots.ElementModel;
import javax.swing.JDialog;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamColor;
import org.rosuda.deducer.widgets.param.ParamLogical;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.ParamRObject;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionDialog;

public class PointsElementModel
extends ElementModel {
    RFunction rf;

    public PointsElementModel() {
        this.init();
    }

    public void init() {
        this.rf = new RFunction("plot");
        ParamRObject paramRObject = new ParamRObject("x");
        paramRObject.setTitle("Spatial points");
        paramRObject.setRObjectClass("SpatialPointsDataFrame");
        paramRObject.setRequired(true);
        this.rf.add((Param)paramRObject);
        ParamLogical paramLogical = new ParamLogical("add");
        paramLogical.setDefaultValue(false);
        paramLogical.setValue(true);
        paramLogical.setViewType("org.rosuda.deducer.widgets.param.ParamNullWidget");
        this.rf.add((Param)paramLogical);
        ParamNumeric paramNumeric = new ParamNumeric("pch");
        paramNumeric.setTitle("Type");
        paramNumeric.setLowerBound(0.5);
        paramNumeric.setUpperBound(25.5);
        paramNumeric.setOptions(new String[]{"1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0", "10.0", "11.0", "12.0", "13.0", "14.0", "15.0", "16.0", "17.0", "18.0", "19.0", "20.0"});
        paramNumeric.setLabels(new String[]{"open circle", "open triangle", "plus", "cross", "open diamond", "open triangle (rev)", "cross square", "star", "plus diamond", "plus circle", "double hourglass", "plus square", "target", "triange square", "solid square", "solid circle", "solid triangle", "solid diamond", "solid circle (big)", "solid circle (small)"});
        paramNumeric.setValue(16.0);
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramNumeric.setRequired(false);
        this.rf.add((Param)paramNumeric);
        paramNumeric = new ParamNumeric("cex");
        paramNumeric.setTitle("Size");
        paramNumeric.setDefaultValue(1.0);
        paramNumeric.setLowerBound(0.0);
        paramNumeric.setValue(1.0);
        this.rf.add((Param)paramNumeric);
        ParamColor paramColor = new ParamColor("col");
        paramColor.setTitle("Color");
        paramColor.setRequired(false);
        this.rf.add((Param)paramColor);
        this.iconLocation = "icons/geo_point.png";
        this.name = "Points";
    }

    public JDialog getView() {
        RFunctionDialog rFunctionDialog = new RFunctionDialog(this.rf);
        rFunctionDialog.setSize(300, 300);
        rFunctionDialog.setRun(false);
        return rFunctionDialog;
    }

    public String getCall() {
        return this.rf.getCall();
    }

    public String checkValid() {
        return this.rf.checkValid();
    }

    public PointsElementModel clone() {
        PointsElementModel pointsElementModel = new PointsElementModel();
        pointsElementModel.rf = (RFunction)this.rf.clone();
        return pointsElementModel;
    }

    public String getDataFrameArgumentName() {
        return (String)this.rf.get(0).getValue();
    }

    public void setDataFrameArgumentName(String string) {
        this.rf.get(0).setValue((Object)string);
    }
}

