% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Horiuchi.R
\name{R0vec}
\alias{R0vec}
\title{R0vec Calculates net reproduction, R0, according to a given set of rates Lx,fx and a fixed
 proportion female of births, \code{pfem}.}
\usage{
R0vec(x, pfem = 0.4886)
}
\arguments{
\item{x}{a single vector containing Lx followed by Fx or vice versa.  Here, \code{Lx} is the survival 
function integrated within each age interval and with a lifetable radix of 1. \code{Fx} is the 
fertility function, calculated as births/ person years of exposure. \code{Fx} should simply contain 
zeros in ages with no fertility, OR, all vectors should be limited to reproductive ages. Both 
\code{Lx} and \code{Fx} should for this function be of the same length.}

\item{pfem}{the proportion female of births. Something like .49, .48, or (1/(2.05)). This can either be specified as a single number, or it may be allowed to vary by age. For the later case, be sure to specify a value for each age (\code{length(x)/2} values). Default .4886.}
}
\value{
the value of R0 for the given set of rates and proportion female of births.
}
\description{
This function is only provided for the examples of \code{horiuchi()}. 
It calculates the sum of the row products of \code{rates} multiplied by \code{pfem}.
}
\details{
The main feature that functions need to have when specified for \code{horiuchi()} or \code{stepwise\_replacement()} is that the rates must all go into a (potentially long) vector, probably consisting in your rate vectors one after the other. Really the decomposition function does not care how things are arranged in the vector- the components of change vector that is returned from \code{horiuchi()} will be  arranged in exactly the same way as its input rate vectors, so as long as you know how to sort it out, and your function can extract what it needs from the vectors, then it can be specified in any way. For this particular example function, \code{R0vec()}, \code{x} must be specified with either Lx followed by Fx or vice versa. It would also be possible to redefine the function to place \code{pfem} in with the rates vector, \code{x}, which would allow this item to be decomposed too. Here it is specified separately in order to demonstrate passing on parameters to the function within \code{horiuchi()}.
}
\examples{
data(rates1)
# take vec:
x <- c(rates1)
R0vec(x)
}
