% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add_node.R
\name{add_node}
\alias{add_node}
\title{Add a node to an existing graph object}
\usage{
add_node(graph, node, from = NULL, to = NULL, label = TRUE, type = NULL,
  ...)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph} that is created using \code{create_graph}.}

\item{node}{a node ID for the newly connected node.}

\item{from}{an optional vector containing node IDs from which edges will be directed to the new node.}

\item{to}{an optional vector containing node IDs to which edges will be directed from the new node.}

\item{label}{a character object for supplying an optional label to the node. Setting to \code{TRUE} ascribes the node ID to the label. Setting to \code{FALSE} yields a blank label.}

\item{type}{an optional string that describes the entity type for the node to be added.}

\item{...}{one or more vectors pertaining to node attributes.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add a new node of a specified type to extant nodes within the graph.
}
\examples{
\dontrun{
# Create an empty graph
graph <- create_graph()

# Add two nodes
graph <- add_node(graph, node = "a")
graph <- add_node(graph, node = "b")
}
}

