% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_info.R
\name{node_info}
\alias{node_info}
\title{Get detailed information on nodes}
\usage{
node_info(graph)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph}.}
}
\value{
a data frame containing information specific to each node within
the graph.
}
\description{
Obtain a data frame with detailed information on nodes and
their interrelationships within a graph.
}
\examples{
\dontrun{
# Create a simple graph and get node information from it
nodes <-
  create_nodes(nodes = LETTERS,
               label = TRUE,
               type = c(rep("a_to_g", 7),
                        rep("h_to_p", 9),
                        rep("q_to_x", 8),
                        rep("y_and_z",2)))

edges <-
  create_edges(from = sample(LETTERS, replace = TRUE),
               to = sample(LETTERS, replace = TRUE),
               label = "edge",
               rel = "letter_to_letter")

graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges,
               graph_attrs = "layout = neato",
               node_attrs = c("fontname = Helvetica",
                              "shape = circle"))

node_info(graph)
#>    node label    type degree indegree outdegree loops
#> 1     A     A  a_to_g      2        0         2     0
#> 2     W     W  q_to_x      1        0         1     0
#> 3     T     T  q_to_x      2        0         2     0
#> 4     L     L  h_to_p      1        0         1     0
#> 5     F     F  a_to_g      0        0         0     0
#>..   ...   ...     ...    ...      ...       ...   ...

# Import a large graph
power_grid <-
import_graph(system.file("examples/power_grid.graphml",
                         package = "DiagrammeR"))

# Use dplyr::filter to determine which nodes are highly
# connected in this graph
library(dplyr)

high_connect_nodes <-
  filter(node_info(power_grid), degree > 10)$node
}
}

