% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_edges_from_table.R
\name{add_edges_from_table}
\alias{add_edges_from_table}
\title{Add edges and attributes to graph from a table}
\usage{
add_edges_from_table(graph, table, from_col, from_mapping = NULL, to_col,
  to_mapping = NULL, set_rel = NULL, select_cols = NULL,
  drop_cols = NULL, rename_attrs = NULL, rel_col = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{table}{either a path to a CSV file, or, a data
frame object.}

\item{from_col}{the name of the table column from
which edges originate.}

\item{from_mapping}{a single character value for
the mapping of a column in the external table
(supplied as \code{from_col}) to a column in the
graph's internal node data frame (ndf).}

\item{to_col}{the name of the table column to
which edges terminate.}

\item{to_mapping}{a single character value for
the mapping of a column in the external table
(supplied as \code{to_col}) to a column in the
graph's internal node data frame (ndf).}

\item{set_rel}{an optional string to apply a
\code{rel} attribute to all edges created from the
table records.}

\item{select_cols}{an optional character vector for
specifying which columns in the table that should be
imported as edge attributes.}

\item{drop_cols}{an optional character vector for
dropping columns from the incoming data.}

\item{rename_attrs}{an optional character vector for
renaming edge attributes.}

\item{rel_col}{an option to apply a column of data
in the table as \code{rel} attribute values.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Add edges and their attributes to an
existing graph object from data in a CSV file or a
data frame.
}
\examples{
\dontrun{
library(magrittr)
library(dplyr)

# Create a graph from a CSV file
graph <- create_graph() \%>\%
add_edges_from_table(
  system.file("examples/projects_and_contributors.csv",
              package = "DiagrammeR"),
  from_col = "contributor_name",
  to_col = "project_name",
  rel_col = "contributor_role",
  set_rel = "contributes_to")

# Get a count of nodes in the graph
node_count(graph)
#> [1] 13

# Get a count of edges in the graph
edge_count(graph)
#> [1] 13
}
}

