% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_edges.R
\name{combine_edges}
\alias{combine_edges}
\title{Combine multiple edge data frames into a single
edge data frame}
\usage{
combine_edges(...)
}
\arguments{
\item{...}{two or more edge data frames, which
contain edge IDs and associated attributes.}
}
\value{
a combined edge data frame.
}
\description{
Combine several edge data frames in
the style of \code{rbind}, except, it works
regardless of the number and ordering of the
columns.
}
\examples{
# Combine two edge data frames
edges_1 <-
  create_edges(
    from = c("a", "a", "b", "c"),
    to = c("b", "d", "d", "a"),
    rel = "requires",
    color = "green",
    data = c(2.7, 8.9, 2.6, 0.6))

edges_2 <-
  create_edges(
    from = c("e", "g", "h", "h"),
    to = c("g", "h", "f", "e"),
    rel = "receives",
    arrowhead = "dot",
    color = "red")

all_edges <-
  combine_edges(edges_1, edges_2)
}

