% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_graph.R
\name{export_graph}
\alias{export_graph}
\title{Export a graph to various file formats}
\usage{
export_graph(graph, file_name = NULL, file_type = NULL, width = NULL,
  height = NULL)
}
\arguments{
\item{graph}{a graph object.}

\item{file_name}{the name of the exported file
(including it's extension).}

\item{file_type}{the type of file to be exported.
Options are: \code{png}, \code{pdf}, \code{svg},
and \code{ps}.}

\item{width}{output width in pixels or \code{NULL}
for default.}

\item{height}{output height in pixels or \code{NULL}
for default.}
}
\description{
Export a graph to a variety of file
formats such as PNG, PDF, SVG, and PostScript.
}
\examples{
\dontrun{
library(magrittr)
library(DiagrammeRsvg)

# Create a node data frame (ndf)
nodes <-
  create_nodes(
    nodes = c("a", "b", "c", "d"),
    type = c("A", "A", "Z", "Z"),
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edges <-
  create_edges(
    from = c("a", "b", "c"),
    to = c("d", "c", "a"),
    rel = c("A", "Z", "A"))

# Create a graph with the ndf and edf
graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges)

# Create a PDF file for the graph (`graph.pdf`)
graph \%>\% export_graph("graph.pdf")

# Create a PNG file for the graph (`mypng`)
graph \%>\%
export_graph(
  file_name = "mypng",
  file_type = "PNG")
}
}

