% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_constraint.R
\name{get_constraint}
\alias{get_constraint}
\title{Get constraint scores for one or more graph nodes}
\usage{
get_constraint(graph, nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{nodes}{an optional vector of node IDs to
consider for constraint scores. If not supplied,
then constraint scores for all nodes in the graph
will be calculated.}
}
\value{
a data frame with constraint scores for one
or more graph nodes.
}
\description{
Get the constraint scores (based on
Burt's Constraint Index) for one or more nodes in a
graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 1)

# Get the constaint scores for all nodes in
# the graph
get_constraint(graph)
#>    node constraint
#> 1     1  0.3536111
#> 2     2  0.4172222
#> 3     3  0.4933333
#> 4     4  0.4528472
#> 5     5  0.3711188
#> 6     6  0.4583333
#> 7     7  0.3735494
#> 8     8  0.3072222
#> 9     9  0.4479167
#> 10   10  0.4447222

# Get the constaint scores for only nodes
# `5` and `7`
get_constraint(graph, c(5, 7))
#>    node constraint
#> 5     5  0.3711188
#> 7     7  0.3735494
}

