% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graph_from_series.R
\name{get_graph_from_series}
\alias{get_graph_from_series}
\title{Get a graph available in a series}
\usage{
get_graph_from_series(graph_series, graph_no)
}
\arguments{
\item{graph_series}{a graph series object of type
\code{dgr_graph_1D}.}

\item{graph_no}{the index of the graph in the graph
series.}
}
\description{
Using a graph series object of type
\code{dgr_graph_1D}, get a graph object.
}
\examples{
library(magrittr)

# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_node("a") \%>\%
  add_node("b") \%>\%
  add_node("c") \%>\%
  add_edge("a", "c") \%>\%
  add_edge("a", "b") \%>\%
  add_edge("b", "c")

graph_2 <-
  graph_1 \%>\%
  add_node("d") \%>\%
  add_edge("d", "c")

graph_3 <-
  graph_2 \%>\%
  add_node("e") \%>\%
  add_edge("e", "b")

# Create an empty graph series and add
# the graphs
series <-
  create_series() \%>\%
  add_to_series(graph_1, .) \%>\%
  add_to_series(graph_2, .) \%>\%
  add_to_series(graph_3, .)

# Get the second graph in the series
extracted_graph <-
  get_graph_from_series(
    graph_series = series,
    graph_no = 2)
}

