% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_nodes.R
\name{select_nodes}
\alias{select_nodes}
\title{Select nodes in a graph}
\usage{
select_nodes(graph, node_attr = NULL, search = NULL, set_op = "union",
  nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{node_attr}{an optional character vector of
node attribute values for filtering the node ID
values returned.}

\item{search}{an option to provide a logical
expression with a comparison operator (\code{>},
\code{<}, \code{==}, or \code{!=}) followed by a
number for numerical filtering, or, a regular
expression for filtering the nodes returned through
string matching.}

\item{set_op}{the set operation to perform upon
consecutive selections of graph nodes. This can
either be as a \code{union} (the default), as an
intersection of selections with \code{intersect},
or, as a \code{difference} on the previous
selection, if it exists.}

\item{nodes}{an optional vector of node IDs for
filtering list of nodes present in the graph.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Select nodes from a graph object of
class \code{dgr_graph}.
}
\examples{
library(magrittr)

# Create a node data frame (ndf)
nodes <-
  create_nodes(
    nodes = c("a", "b", "c", "d"),
    type = c("A", "A", "Z", "Z"),
    label = TRUE,
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edges <-
  create_edges(
    from = c("a", "b", "c"),
    to = c("d", "c", "a"),
    rel = c("A", "Z", "A"))

# Create a graph with the ndf and edf
graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges)

# Explicitly select nodes `a` and `c`
graph <-
  graph \%>\%
  select_nodes(
    nodes = c("a", "c"))

# Verify that the node selection has been made
# using the `get_selection()` function
get_selection(graph)
#> $nodes
#> [1] "a" "c"

# Select nodes based on the node `type`
# being `Z`
graph <-
  graph \%>\%
  clear_selection \%>\%
  select_nodes(
    node_attr = "type",
    search = "Z")

# Verify that an node selection has been made, and
# recall that the `c` and `d` nodes are of the
# `Z` type
get_selection(graph)
#> $nodes
#> [1] "c" "d"

# Select edges based on the node value attribute
# being greater than 3.0 (first clearing the current
# selection of nodes)
graph <-
  graph \%>\%
  clear_selection \%>\%
  select_nodes(
    node_attr = "value",
    search = ">3.0")

# Verify that the correct node selection has been
# made; in this case, nodes `a` and `c` have values
# for `value` greater than 3.0
get_selection(graph)
#> $nodes
#> [1] "a" "c"
}

