% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_node_df.R
\name{get_node_df}
\alias{get_node_df}
\title{Get a node data frame from a graph}
\usage{
get_node_df(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a node data frame.
}
\description{
From a graph, obtain a node data frame
with all current node attributes.
}
\examples{
# Create a graph using several piped functions
graph <-
  create_graph() \%>\%
  add_n_nodes(1, "a") \%>\%
  select_last_node \%>\%
  add_n_nodes_ws(5, "from", "b") \%>\%
  select_nodes_by_id(1) \%>\%
  set_node_attrs_ws(
    "value", 25.3) \%>\%
  clear_selection() \%>\%
  select_nodes_by_id(2:4) \%>\%
  set_node_attrs_ws(
    "color", "grey70") \%>\%
  invert_selection() \%>\%
  set_node_attrs_ws(
    "color", "grey80") \%>\%
  clear_selection

# Get the graph's internal node
# data frame (ndf)
graph \%>\% get_node_df()
#>   id type label value  color
#> 1  1    a  <NA>  25.3 grey80
#> 2  2    b  <NA>    NA grey70
#> 3  3    b  <NA>    NA grey70
#> 4  4    b  <NA>    NA grey70
#> 5  5    b  <NA>    NA grey80
#> 6  6    b  <NA>    NA grey80
}

