% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_property_graph.R
\name{is_property_graph}
\alias{is_property_graph}
\title{Is the graph a property graph?}
\usage{
is_property_graph(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a logical value.
# Create a graph with 2 nodes (with `type`
# values) and a single edge (with a `rel`)
simple_property_graph <-
  create_graph() %>%
  add_node(
    type = "a",
    label = "first") %>%
  add_node(
    type = "b",
    label = "second") %>%
  add_edge(
    from = "first",
    to = "second",
    rel = "rel_1")

# This is a property graph but confirm
# that this is TRUE by using the
# `is_property_graph()` function
is_property_graph(simple_property_graph)
#> [1] TRUE

# If a `type` attribute is removed, then
# this graph will no longer be a property
# graph
simple_property_graph %>%
  node_type(
    node = get_node_ids(
      .,
      "label == 'first'"),
    "delete") %>%
is_property_graph()
#> [1] FALSE

# An empty graph will return FALSE
create_graph() %>%
  is_property_graph()
#> [1] FALSE
}
\description{
Provides a logical value on whether
the graph is property graph (i.e., all nodes have
an assigned \code{type} value and all edges have
an assigned \code{rel} value).
}
