% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_edge.R
\name{add_edge}
\alias{add_edge}
\title{Add an edge between nodes in a graph object}
\usage{
add_edge(graph, from, to, rel = NULL, ...)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{from}{the outgoing node from which the edge
is connected. There is the option to use a node
\code{label} value here (and this must
correspondingly also be done for the \code{to}
argument) for defining node connections. Note that
this is only possible if all nodes have distinct
\code{label} values set and none exist as an empty
string.}

\item{to}{the incoming nodes to which each edge
is connected. There is the option to use a node
\code{label} value here (and this must
correspondingly also be done for the \code{from}
argument) for defining node connections. Note that
this is only possible if all nodes have distinct
\code{label} values set and none exist as an empty
string.}

\item{rel}{an optional string specifying the
relationship between the
connected nodes.}

\item{...}{optional edge attributes supplied as
vectors.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add an edge to nodes within the
graph.
}
\examples{
# Create a graph with 4 nodes
graph <-
  create_graph() \%>\%
  add_node(label = "one") \%>\%
  add_node(label = "two") \%>\%
  add_node(label = "three") \%>\%
  add_node(label = "four")

# Add an edge between those nodes and attach a
# relationship to the edge
graph <-
 add_edge(
   graph,
   from = 1,
   to = 2,
   rel = "A")

# Use the `edge_info()` function to verify that
# the edge has been created
edge_info(graph)
#>   id from to rel
#> 1  1    1  2   A

# Add another node and edge to the graph
graph <-
  graph \%>\%
  add_edge(
    from = 3,
    to = 2,
    rel = "A")

# Verify that the edge has been created by
# getting a count of graph edges
edge_count(graph)
#> [1] 2

# Add edges by specifying node `label`
# values; note that all nodes must have
# unique `label` values to use this option
graph <-
  graph \%>\%
  add_edge(
    from = "three",
    to = "four",
    rel = "L") \%>\%
  add_edge(
    from = "four",
    to = "one",
    rel = "L")

# Use the `get_edges()` function to verify
# that the edges were added
get_edges(graph)
#> [1] "1->2" "3->2" "3->4" "4->1"
}
