% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_constraint.R
\name{get_constraint}
\alias{get_constraint}
\title{Get constraint scores for one or more graph nodes}
\usage{
get_constraint(graph, nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{nodes}{an optional vector of node IDs to
consider for constraint scores. If not supplied,
then constraint scores for all nodes in the graph
will be calculated.}
}
\value{
a data frame with constraint scores for one
or more graph nodes.
}
\description{
Get the constraint scores (based on
Burt's Constraint Index) for one or more nodes in a
graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the constaint scores for all
# nodes in the graph
get_constraint(graph)
#>    id constraint
#> 1   1  0.2986111
#> 2   2  0.6400000
#> 3   3  1.2222222
#> 4   4  0.4197531
#> 5   5  0.5000000
#> 6   6  0.3333333
#> 7   7  1.0000000
#> 8   8  0.0000000
#> 9   9  1.0000000
#> 10 10  0.0000000

# Get the constaint scores for only nodes
# `5` and `7`
get_constraint(graph, nodes = c(5, 7))
#>   id constraint
#> 1  5        0.5
#> 2  7        1.0

# Add the constraint scores to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_constraint(.))

# Display the graph's node data frame
get_node_df(graph)
#>    id type label value constraint
#> 1   1 <NA>     1   6.0  0.2986111
#> 2   2 <NA>     2   2.5  0.6400000
#> 3   3 <NA>     3   3.5  1.2222222
#> 4   4 <NA>     4   7.5  0.4197531
#> 5   5 <NA>     5   8.5  0.5000000
#> 6   6 <NA>     6   4.5  0.3333333
#> 7   7 <NA>     7  10.0  1.0000000
#> 8   8 <NA>     8  10.0  0.0000000
#> 9   9 <NA>     9   8.5  1.0000000
#> 10 10 <NA>    10  10.0  0.0000000
}
