% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_global_graph_attrs.R
\name{set_global_graph_attrs}
\alias{set_global_graph_attrs}
\title{Set global graph attributes}
\usage{
set_global_graph_attrs(graph, attr, value, attr_type)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{attr}{the name of the attribute to
set for the \code{type} of global attribute
specified.}

\item{value}{the value to be set for the chosen
attribute specified in the \code{attr_for_type}
argument.}

\item{attr_type}{the specific type of global graph
attribute to set. The type is specified with
\code{graph}, \code{node}, or \code{edge}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Set global attributes of a specific
type (either \code{graph_attrs}, \code{node_attrs},
or \code{edge_attrs} for a graph object of class
\code{dgr_graph}).
}
\examples{
# Create a new graph and set some global attributes
graph <-
  create_graph() \%>\%
  set_global_graph_attrs(
    attr = "overlap",
    value = "true",
    attr_type = "graph")

# Verify that the global attributes have been set
get_global_graph_attrs(graph)
#>      attr value attr_type
#> 1 overlap  true     graph
}
