% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rev_edge_dir_ws.R
\name{rev_edge_dir_ws}
\alias{rev_edge_dir_ws}
\title{Reverse the direction of selected edges in a graph}
\usage{
rev_edge_dir_ws(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Using a directed graph with a selection
of edges as input, reverse the direction of those
selected edges in input graph.
}
\examples{
# Create a graph with a
# directed tree
graph <-
  create_graph() \%>\%
  add_balanced_tree(
    k = 2, h = 2)

# Inspect the graph's edges
graph \%>\%
  get_edges()

# Select all edges associated
# with nodes `1` and `2`
graph <-
  graph \%>\%
  select_edges_by_node_id(
    nodes = 1:2)

# Reverse the edge directions
# of the edges associated with
# nodes `1` and `2`
graph <-
  graph \%>\%
  rev_edge_dir_ws()

# Inspect the graph's edges
# after their reversal
graph \%>\%
  get_edges()
}
